/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.example;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.GraphModel;

public class GraphTreeModel
extends DefaultTreeModel
implements GraphModelListener {
    public static void main(String[] args) {
        JFrame frame = new JFrame("GraphTreeModel");
        JGraph graph = new JGraph();
        GraphTreeModel gtModel = new GraphTreeModel(graph.getModel());
        JTree tree = new JTree(gtModel);
        graph.getModel().addGraphModelListener(gtModel);
        tree.setRootVisible(false);
        JScrollPane sGraph = new JScrollPane(graph);
        JScrollPane sTree = new JScrollPane(tree);
        JSplitPane pane = new JSplitPane(1, sTree, sGraph);
        frame.getContentPane().add(pane);
        frame.pack();
        frame.setVisible(true);
    }

    public GraphTreeModel(GraphModel model) {
        super(new GraphModelTreeNode(model));
    }

    public void graphChanged(GraphModelEvent e) {
        this.reload();
    }

    public static class GraphModelTreeNode
    implements TreeNode {
        protected GraphModel model;

        public GraphModelTreeNode(GraphModel model) {
            this.model = model;
        }

        public Enumeration children() {
            Vector<Object> v = new Vector<Object>();
            int i = 0;
            while (i < this.model.getRootCount()) {
                v.add(this.model.getRootAt(i));
                ++i;
            }
            return v.elements();
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public TreeNode getChildAt(int childIndex) {
            return (TreeNode)this.model.getRootAt(childIndex);
        }

        public int getChildCount() {
            return this.model.getRootCount();
        }

        public int getIndex(TreeNode node) {
            return this.model.getIndexOfRoot(node);
        }

        public TreeNode getParent() {
            return null;
        }

        public boolean isLeaf() {
            return false;
        }

        public String toString() {
            return this.model.toString();
        }
    }
}

