/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.example;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.Port;

public class HelloWorld {
    public static void main(String[] args) {
        DefaultGraphModel model = new DefaultGraphModel();
        JGraph graph = new JGraph(model);
        graph.setSelectNewCells(true);
        Hashtable<DefaultGraphCell, AttributeMap> attributes = new Hashtable<DefaultGraphCell, AttributeMap>();
        DefaultGraphCell hello = new DefaultGraphCell("Hello");
        AttributeMap helloAttrib = model.createAttributes();
        attributes.put(hello, helloAttrib);
        Rectangle2D helloBounds = helloAttrib.createRect(20.0, 20.0, 40.0, 20.0);
        GraphConstants.setBounds(helloAttrib, helloBounds);
        GraphConstants.setBorderColor(helloAttrib, Color.black);
        DefaultPort hp = new DefaultPort();
        hello.add(hp);
        DefaultGraphCell world = new DefaultGraphCell("World");
        AttributeMap worldAttrib = model.createAttributes();
        attributes.put(world, worldAttrib);
        Rectangle2D worldBounds = worldAttrib.createRect(140.0, 140.0, 40.0, 20.0);
        GraphConstants.setBounds(worldAttrib, worldBounds);
        GraphConstants.setBackground(worldAttrib, Color.orange);
        GraphConstants.setOpaque(worldAttrib, true);
        GraphConstants.setBorder(worldAttrib, BorderFactory.createRaisedBevelBorder());
        DefaultPort wp = new DefaultPort();
        world.add(wp);
        DefaultEdge edge = new DefaultEdge();
        AttributeMap edgeAttrib = model.createAttributes();
        attributes.put(edge, edgeAttrib);
        int arrow = 1;
        GraphConstants.setLineEnd(edgeAttrib, arrow);
        GraphConstants.setEndFill(edgeAttrib, true);
        ConnectionSet cs = new ConnectionSet((Edge)edge, (Port)hp, wp);
        Object[] cells = new Object[]{edge, hello, world};
        model.insert(cells, attributes, cs, null, null);
        JFrame frame = new JFrame();
        frame.getContentPane().add(new JScrollPane(graph));
        frame.pack();
        frame.setVisible(true);
    }
}

