/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.DefaultGraphCellEditor;
import org.jgraph.graph.GraphCellEditor;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphModel;

public abstract class AbstractCellView
implements CellView,
Serializable {
    protected static GraphCellEditor cellEditor = new DefaultGraphCellEditor();
    protected JGraph graph = null;
    protected CellMapper mapper = null;
    protected Object cell = null;
    protected CellView parent = null;
    protected List childViews = new ArrayList();
    protected AttributeMap attributes = new AttributeMap();
    protected AttributeMap allAttributes;

    public AbstractCellView(Object cell, JGraph graph, CellMapper mapper) {
        this.cell = cell;
        this.graph = graph;
        this.mapper = mapper;
        this.updateAllAttributes();
    }

    public JGraph getGraph() {
        return this.graph;
    }

    public GraphModel getModel() {
        return this.graph.getModel();
    }

    public CellMapper getMapper() {
        return this.mapper;
    }

    public Object getCell() {
        return this.cell;
    }

    public void refresh(boolean createDependentViews) {
        boolean reorder;
        this.update();
        if (this.mapper != null && this.getModel() != null) {
            Object par = this.getModel().getParent(this.cell);
            if (this.graph.getGraphLayoutCache().isVisible(par)) {
                CellView tmp = this.mapper.getMapping(par, createDependentViews);
                if (tmp != this.parent) {
                    this.removeFromParent();
                }
                this.parent = tmp;
            } else if (this.parent != null) {
                this.removeFromParent();
                this.parent = null;
            }
        }
        boolean bl = reorder = !this.graph.getGraphLayoutCache().isOrdered();
        if (reorder) {
            this.childViews.clear();
        }
        GraphModel model = this.getModel();
        int i = 0;
        while (i < model.getChildCount(this.cell)) {
            CellView view;
            Object child = model.getChild(this.cell, i);
            if (this.graph.getGraphLayoutCache().isVisible(child) && (view = this.mapper.getMapping(child, createDependentViews)) != null && !model.isPort(child) && (!this.childViews.contains(view) || reorder)) {
                this.childViews.add(view);
            }
            ++i;
        }
    }

    public void update() {
        this.updateAllAttributes();
        this.childUpdated();
    }

    protected void updateAllAttributes() {
        this.allAttributes = this.getModel().getAttributes(this.cell);
        this.allAttributes = this.allAttributes != null ? (AttributeMap)this.allAttributes.clone() : this.getModel().createAttributes();
        this.allAttributes.putAll(this.attributes);
    }

    public void childUpdated() {
        if (this.parent != null) {
            this.parent.childUpdated();
        }
    }

    public CellView getParentView() {
        return this.parent;
    }

    public CellView[] getChildViews() {
        CellView[] array = new CellView[this.childViews.size()];
        this.childViews.toArray(array);
        return array;
    }

    public static CellView[] getDescendantViews(CellView[] views) {
        Stack<CellView> stack = new Stack<CellView>();
        int i = 0;
        while (i < views.length) {
            stack.add(views[i]);
            ++i;
        }
        ArrayList<CellView> result = new ArrayList<CellView>();
        while (!stack.isEmpty()) {
            CellView tmp = (CellView)stack.pop();
            CellView[] children = tmp.getChildViews();
            int i2 = 0;
            while (i2 < children.length) {
                stack.add(children[i2]);
                ++i2;
            }
            result.add(tmp);
        }
        CellView[] ret = new CellView[result.size()];
        result.toArray(ret);
        return ret;
    }

    public void removeFromParent() {
        if (this.parent instanceof AbstractCellView) {
            List list = ((AbstractCellView)this.parent).childViews;
            list.remove(this);
        }
    }

    public boolean isLeaf() {
        return this.childViews.isEmpty();
    }

    public AttributeMap getAttributes() {
        return this.attributes;
    }

    public AttributeMap getAllAttributes() {
        return this.allAttributes;
    }

    public AttributeMap setAttributes(AttributeMap change) {
        AttributeMap undo = this.attributes.applyMap(change);
        this.update();
        return undo;
    }

    public abstract Rectangle2D getBounds();

    public static Rectangle2D getBounds(CellView[] views) {
        if (views != null && views.length > 0) {
            Rectangle2D ret = null;
            int i = 0;
            while (i < views.length) {
                Rectangle2D r;
                if (views[i] != null && (r = views[i].getBounds()) != null) {
                    if (ret == null) {
                        ret = views[i].getAttributes().createRect(r);
                    } else {
                        Rectangle2D.union(ret, r, ret);
                    }
                }
                ++i;
            }
            return ret;
        }
        return null;
    }

    public void setBounds(Rectangle2D bounds) {
        Rectangle2D oldBounds = this.getBounds();
        if (oldBounds == null) {
            oldBounds = this.getAttributes().createRect();
        }
        Point2D p0 = this.getAttributes().createPoint(oldBounds.getX(), oldBounds.getY());
        Point2D pe = this.getAttributes().createPoint(bounds.getX(), bounds.getY());
        Rectangle2D localBounds = this.getAttributes().createRect(bounds);
        if (GraphConstants.isMoveable(this.getAttributes()) && !pe.equals(p0)) {
            this.translate(pe.getX() - p0.getX(), pe.getY() - p0.getY());
        } else {
            localBounds.setFrame(localBounds.getX(), localBounds.getY(), bounds.getWidth() - pe.getX() + p0.getX(), bounds.getHeight() - pe.getY() + p0.getY());
        }
        double lbw = localBounds.getWidth();
        double lbh = localBounds.getHeight();
        double obw = oldBounds.getWidth();
        double obh = oldBounds.getHeight();
        if ((lbw != obw || lbh != obh) && obw > 0.0 && obh > 0.0) {
            this.scale(lbw / obw, lbh / obh, pe);
        }
    }

    protected void translate(double dx, double dy) {
        if (this.isLeaf()) {
            this.getAttributes().translate(dx, dy);
        } else {
            Iterator it = this.childViews.iterator();
            while (it.hasNext()) {
                Object view = it.next();
                if (!(view instanceof AbstractCellView)) continue;
                AbstractCellView child = (AbstractCellView)view;
                child.translate(dx, dy);
            }
        }
    }

    protected void scale(double sx, double sy, Point2D origin) {
        if (this.isLeaf()) {
            this.getAttributes().scale(sx, sy, origin);
        } else {
            Iterator it = this.childViews.iterator();
            while (it.hasNext()) {
                AbstractCellView child;
                AttributeMap attributes;
                Object view = it.next();
                if (!(view instanceof AbstractCellView) || !GraphConstants.isSizeable(attributes = (child = (AbstractCellView)view).getAttributes()) && !GraphConstants.isAutoSize(attributes)) continue;
                child.scale(sx, sy, origin);
            }
        }
    }

    public boolean intersects(Graphics g, Rectangle2D rect) {
        if (this.isLeaf()) {
            Rectangle2D bounds = this.getBounds();
            if (bounds != null) {
                return bounds.intersects(rect);
            }
        } else {
            Iterator it = this.childViews.iterator();
            while (it.hasNext()) {
                if (!((CellView)it.next()).intersects(g, rect)) continue;
                return true;
            }
        }
        return false;
    }

    public Component getRendererComponent(JGraph graph, boolean selected, boolean focus, boolean preview) {
        CellViewRenderer cvr = this.getRenderer();
        if (cvr != null) {
            return cvr.getRendererComponent(graph, this, selected, focus, preview);
        }
        return null;
    }

    public abstract CellViewRenderer getRenderer();

    public abstract CellHandle getHandle(GraphContext var1);

    public GraphCellEditor getEditor() {
        return cellEditor;
    }
}

