/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.PortView;

public class AttributeMap
extends Hashtable {
    public AttributeMap() {
    }

    public AttributeMap(Map map) {
        super(map);
    }

    public Point2D createPoint() {
        return new SerializablePoint2D();
    }

    public Point2D createPoint(Point2D p) {
        if (p != null) {
            return this.createPoint(p.getX(), p.getY());
        }
        return null;
    }

    public Point2D createPoint(double x, double y) {
        return new SerializablePoint2D(x, y);
    }

    public Rectangle2D createRect() {
        return new SerializableRectangle2D();
    }

    public Rectangle2D createRect(double x, double y, double w, double h) {
        return new SerializableRectangle2D(x, y, w, h);
    }

    public Rectangle2D createRect(Point2D pt) {
        return this.createRect(pt, 0.0);
    }

    public Rectangle2D createRect(Point2D pt, double size) {
        if (pt != null) {
            return this.createRect(pt.getX(), pt.getY(), size, size);
        }
        return null;
    }

    public Rectangle2D createRect(Rectangle2D rect) {
        if (rect != null) {
            return this.createRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        }
        return null;
    }

    public Rectangle2D createRect(double x, double y, double w, double h, double grow1, double grow2) {
        return this.createRect(x - grow1, y - grow1, w + grow1 + grow2, h + grow1 + grow2);
    }

    public Rectangle2D createRect(Rectangle2D rect, double grow1, double grow2) {
        if (rect != null) {
            return this.createRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), grow1, grow2);
        }
        return null;
    }

    public AttributeMap applyMap(Map change) {
        AttributeMap undo = new AttributeMap();
        if (change != null) {
            Object[] remove;
            if (GraphConstants.isRemoveAll(change)) {
                undo.putAll(this);
                this.clear();
            }
            if ((remove = GraphConstants.getRemoveAttributes(change)) != null) {
                int i = 0;
                while (i < remove.length) {
                    Object oldValue = this.remove(remove[i]);
                    if (oldValue != null) {
                        undo.put(remove[i], oldValue);
                    }
                    ++i;
                }
            }
            HashSet removeAttributes = new HashSet();
            Iterator it = change.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object key = entry.getKey();
                if (key.equals("removeAll") || key.equals("removeAttributes")) continue;
                Object oldValue = this.put(key, entry.getValue());
                if (oldValue == null) {
                    removeAttributes.add(key);
                    continue;
                }
                undo.put(key, oldValue);
            }
            if (!removeAttributes.isEmpty()) {
                GraphConstants.setRemoveAttributes(undo, removeAttributes.toArray());
            }
        }
        return undo;
    }

    public List clonePoints(List points) {
        ArrayList newList = new ArrayList();
        Iterator it = points.iterator();
        while (it.hasNext()) {
            Object point = it.next();
            if (point instanceof PortView) {
                point = ((PortView)point).getLocation(null);
            } else if (point instanceof Point2D) {
                point = this.createPoint((Point2D)point);
            }
            newList.add(point);
        }
        return newList;
    }

    public static void translate(Collection c, double dx, double dy) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object map = it.next();
            if (!(map instanceof AttributeMap)) continue;
            ((AttributeMap)map).translate(dx, dy);
        }
    }

    public void translate(double dx, double dy) {
        if (GraphConstants.isMoveable(this)) {
            List points;
            Rectangle2D bounds = GraphConstants.getBounds(this);
            if (bounds != null) {
                int moveableAxis = GraphConstants.getMoveableAxis(this);
                if (moveableAxis == 1) {
                    dy = 0.0;
                } else if (moveableAxis == 2) {
                    dx = 0.0;
                }
                bounds.setFrame(bounds.getX() + dx, bounds.getY() + dy, bounds.getWidth(), bounds.getHeight());
            }
            if ((points = GraphConstants.getPoints(this)) != null) {
                int i = 0;
                while (i < points.size()) {
                    Object obj = points.get(i);
                    if (obj instanceof Point2D) {
                        Point2D pt = (Point2D)obj;
                        pt.setLocation(pt.getX() + dx, pt.getY() + dy);
                    }
                    ++i;
                }
            }
        }
    }

    public void scale(double sx, double sy, Point2D origin) {
        List points;
        Rectangle2D bounds = GraphConstants.getBounds(this);
        if (bounds != null) {
            Point2D p = this.createPoint(bounds.getX(), bounds.getY());
            Point2D loc = (Point2D)p.clone();
            int sizeableAxis = GraphConstants.getSizeableAxis(this);
            if (sizeableAxis == 1) {
                sy = 1.0;
            } else if (sizeableAxis == 2) {
                sx = 1.0;
            }
            p.setLocation(origin.getX() + (double)Math.round((p.getX() - origin.getX()) * sx), origin.getY() + (double)Math.round((p.getY() - origin.getY()) * sy));
            if (!p.equals(loc)) {
                this.translate(p.getX() - loc.getX(), p.getY() - loc.getY());
            }
            double w = Math.max(1L, Math.round(bounds.getWidth() * sx));
            double h = Math.max(1L, Math.round(bounds.getHeight() * sy));
            bounds.setFrame(bounds.getX(), bounds.getY(), w, h);
        }
        if ((points = GraphConstants.getPoints(this)) != null) {
            Iterator it = points.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof Point2D)) continue;
                Point2D loc = (Point2D)obj;
                Point2D p = (Point2D)loc.clone();
                p.setLocation(origin.getX() + (double)Math.round((p.getX() - origin.getX()) * sx), origin.getY() + (double)Math.round((p.getY() - origin.getY()) * sy));
                loc.setLocation(p);
            }
        }
    }

    public AttributeMap diff(AttributeMap newState) {
        AttributeMap diff = new AttributeMap();
        Iterator it = newState.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Object newValue = entry.getValue();
            Object oldValue = this.get(key);
            if (oldValue != null && oldValue.equals(newValue)) continue;
            diff.put(key, newValue);
        }
        return diff;
    }

    public Object clone() {
        Point label;
        List points;
        AttributeMap newMap = new AttributeMap((Map)this);
        Rectangle2D bounds = GraphConstants.getBounds(newMap);
        if (bounds != null) {
            GraphConstants.setBounds(newMap, (Rectangle2D)bounds.clone());
        }
        if ((points = GraphConstants.getPoints(newMap)) != null) {
            GraphConstants.setPoints(newMap, this.clonePoints(points));
        }
        if ((label = GraphConstants.getLabelPosition(newMap)) != null) {
            GraphConstants.setLabelPosition(newMap, new Point(label));
        }
        return newMap;
    }

    public static class SerializablePoint2D
    extends Point2D.Double
    implements Serializable {
        public SerializablePoint2D() {
        }

        public SerializablePoint2D(double x, double y) {
            super(x, y);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeObject(new Double(this.getX()));
            out.writeObject(new Double(this.getY()));
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            Double x = (Double)in.readObject();
            Double y = (Double)in.readObject();
            this.setLocation(x, y);
        }
    }

    public static class SerializableRectangle2D
    extends Rectangle2D.Double
    implements Serializable {
        public SerializableRectangle2D() {
        }

        public SerializableRectangle2D(double x, double y, double width, double height) {
            super(x, y, width, height);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeObject(new Double(this.getX()));
            out.writeObject(new Double(this.getY()));
            out.writeObject(new Double(this.getWidth()));
            out.writeObject(new Double(this.getHeight()));
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            Double x = (Double)in.readObject();
            Double y = (Double)in.readObject();
            Double width = (Double)in.readObject();
            Double height = (Double)in.readObject();
            this.setFrame(x, y, width, height);
        }
    }
}

