/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;

public class BasicMarqueeHandler {
    protected transient Cursor previousCursor = null;
    protected Rectangle2D marqueeBounds;
    protected Point2D startPoint;
    protected Point2D currentPoint;

    public boolean isForceMarqueeEvent(MouseEvent event) {
        return event.isAltDown();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mouseReleased(MouseEvent e) {
        try {
            if (e != null && this.marqueeBounds != null) {
                if (!(e.getSource() instanceof JGraph)) {
                    throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + e);
                }
                JGraph graph = (JGraph)e.getSource();
                Rectangle2D bounds = graph.fromScreen((Rectangle2D)this.marqueeBounds.clone());
                CellView[] views = graph.getGraphLayoutCache().getRoots(bounds);
                ArrayList<Object> list = new ArrayList<Object>();
                int i = 0;
                while (i < views.length) {
                    if (bounds.contains(views[i].getBounds())) {
                        list.add(views[i].getCell());
                    }
                    ++i;
                }
                Object[] cells = list.toArray();
                graph.getUI().selectCellsForEvent(graph, cells, e);
                graph.setCursor(this.previousCursor);
                Rectangle dirty = new Rectangle((int)this.marqueeBounds.getX(), (int)this.marqueeBounds.getY(), (int)this.marqueeBounds.getWidth() + 1, (int)this.marqueeBounds.getHeight() + 1);
                ++dirty.width;
                ++dirty.height;
                graph.repaint(dirty);
            }
            Object var8_11 = null;
            this.currentPoint = null;
            this.startPoint = null;
            this.marqueeBounds = null;
            this.previousCursor = null;
            return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.currentPoint = null;
            this.startPoint = null;
            this.marqueeBounds = null;
            this.previousCursor = null;
            throw throwable;
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.startPoint != null) {
            if (!(e.getSource() instanceof JGraph)) {
                throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + e);
            }
            JGraph graph = (JGraph)e.getSource();
            Graphics g = graph.getGraphics();
            Color bg = graph.getBackground();
            Color fg = graph.getMarqueeColor();
            g.setColor(fg);
            g.setXORMode(bg);
            this.overlay(g);
            this.currentPoint = e.getPoint();
            this.marqueeBounds = new Rectangle2D.Double(this.startPoint.getX(), this.startPoint.getY(), 0.0, 0.0);
            this.marqueeBounds.add(this.currentPoint);
            g.setColor(bg);
            g.setXORMode(fg);
            this.overlay(g);
        }
    }

    public void paint(Graphics g) {
        this.overlay(g);
    }

    public void overlay(Graphics g) {
        if (this.marqueeBounds != null) {
            g.drawRect((int)this.marqueeBounds.getX(), (int)this.marqueeBounds.getY(), (int)this.marqueeBounds.getWidth(), (int)this.marqueeBounds.getHeight());
        }
    }

    public void mousePressed(MouseEvent e) {
        if (!(e.getSource() instanceof JGraph)) {
            throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + e);
        }
        JGraph graph = (JGraph)e.getSource();
        this.startPoint = e.getPoint();
        this.marqueeBounds = new Rectangle2D.Double(this.startPoint.getX(), this.startPoint.getY(), 0.0, 0.0);
        this.previousCursor = graph.getCursor();
        graph.setCursor(new Cursor(1));
    }

    public void mouseMoved(MouseEvent e) {
    }

    public Point2D getCurrentPoint() {
        return this.currentPoint;
    }

    public Rectangle2D getMarqueeBounds() {
        return this.marqueeBounds;
    }

    public Cursor getPreviousCursor() {
        return this.previousCursor;
    }

    public Point2D getStartPoint() {
        return this.startPoint;
    }

    public void setCurrentPoint(Point2D currentPoint) {
        this.currentPoint = currentPoint;
    }

    public void setMarqueeBounds(Rectangle2D marqueeBounds) {
        this.marqueeBounds = marqueeBounds;
    }

    public void setPreviousCursor(Cursor previousCursor) {
        this.previousCursor = previousCursor;
    }

    public void setStartPoint(Point2D startPoint) {
        this.startPoint = startPoint;
    }
}

