/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.PortView;

public class DefaultEdge
extends DefaultGraphCell
implements Edge {
    protected Object source;
    protected Object target;

    public DefaultEdge() {
        this(null);
    }

    public DefaultEdge(Object userObject) {
        this(userObject, false);
    }

    public DefaultEdge(Object userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
        this.checkDefaults();
    }

    protected void checkDefaults() {
        Point labelPosition;
        List points = GraphConstants.getPoints(this.attributes);
        if (points == null) {
            ArrayList<Point2D> defaultPoints = new ArrayList<Point2D>();
            defaultPoints.add(this.getAttributes().createPoint(10.0, 10.0));
            defaultPoints.add(this.getAttributes().createPoint(20.0, 20.0));
            GraphConstants.setPoints(this.attributes, defaultPoints);
        }
        if ((labelPosition = GraphConstants.getLabelPosition(this.attributes)) == null) {
            int center = 500;
            labelPosition = new Point(center, center);
            GraphConstants.setLabelPosition(this.attributes, labelPosition);
        }
    }

    public AttributeMap changeAttributes(AttributeMap change) {
        AttributeMap undo = super.changeAttributes(change);
        this.checkDefaults();
        return undo;
    }

    public Object getSource() {
        return this.source;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setSource(Object port) {
        this.source = port;
    }

    public void setTarget(Object port) {
        this.target = port;
    }

    public Object clone() {
        DefaultEdge c = (DefaultEdge)super.clone();
        c.source = null;
        c.target = null;
        return c;
    }

    public static class DefaultRouting
    implements Edge.Routing {
        public void route(EdgeView edge, List points) {
            int n = points.size();
            Point2D from = edge.getPoint(0);
            if (edge.getSource() instanceof PortView) {
                from = ((PortView)edge.getSource()).getLocation(null);
            } else if (edge.getSource() != null) {
                Rectangle2D b = edge.getSource().getBounds();
                from = edge.getAttributes().createPoint(b.getCenterX(), b.getCenterY());
            }
            Point2D to = edge.getPoint(n - 1);
            if (edge.getTarget() instanceof PortView) {
                to = ((PortView)edge.getTarget()).getLocation(null);
            } else if (edge.getTarget() != null) {
                Rectangle2D b = edge.getTarget().getBounds();
                to = edge.getAttributes().createPoint(b.getCenterX(), b.getCenterY());
            }
            if (from != null && to != null) {
                Point2D[] routed;
                if (edge.getSource() == edge.getTarget() && edge.getSource() != null) {
                    Rectangle2D bounds = edge.getSource().getParentView().getBounds();
                    double height = edge.getGraph().getGridSize();
                    double width = bounds.getWidth() / 3.0;
                    routed = new Point2D[]{edge.getAttributes().createPoint(bounds.getX() + width, bounds.getY() + bounds.getHeight()), edge.getAttributes().createPoint(bounds.getX() + width, bounds.getY() + bounds.getHeight() + height), edge.getAttributes().createPoint(bounds.getX() + 2.0 * width, bounds.getY() + bounds.getHeight() + height), edge.getAttributes().createPoint(bounds.getX() + 2.0 * width, bounds.getY() + bounds.getHeight())};
                } else {
                    double dx = Math.abs(from.getX() - to.getX());
                    double dy = Math.abs(from.getY() - to.getY());
                    double x2 = from.getX() + (to.getX() - from.getX()) / 2.0;
                    double y2 = from.getY() + (to.getY() - from.getY()) / 2.0;
                    routed = new Point2D[2];
                    if (dx > dy) {
                        routed[0] = edge.getAttributes().createPoint(x2, from.getY());
                        routed[1] = edge.getAttributes().createPoint(x2, to.getY());
                    } else {
                        routed[0] = edge.getAttributes().createPoint(from.getX(), y2);
                        routed[1] = edge.getAttributes().createPoint(to.getX(), y2);
                    }
                }
                int i = 0;
                while (i < routed.length) {
                    if (points.size() > i + 2) {
                        points.set(i + 1, routed[i]);
                    } else {
                        points.add(i + 1, routed[i]);
                    }
                    ++i;
                }
                while (points.size() > routed.length + 2) {
                    points.remove(points.size() - 2);
                }
            }
        }
    }
}

