/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphConstants;

public class DefaultGraphCell
extends DefaultMutableTreeNode
implements GraphCell,
Cloneable {
    public static final Rectangle defaultBounds = new Rectangle(10, 10, 20, 20);
    protected AttributeMap attributes = new AttributeMap();

    public DefaultGraphCell() {
        this(null);
    }

    public DefaultGraphCell(Object userObject) {
        this(userObject, null);
    }

    public DefaultGraphCell(Object userObject, MutableTreeNode[] children) {
        super(userObject, true);
        this.setUserObject(userObject);
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                this.add(children[i]);
                ++i;
            }
        }
        GraphConstants.setBounds(this.attributes, defaultBounds);
    }

    public DefaultGraphCell(Object userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
    }

    public void setUserObject(Object obj) {
        super.setUserObject(obj);
        obj = this.getUserObject();
        if (obj == null) {
            GraphConstants.setValue(this.attributes, "");
        } else {
            GraphConstants.setValue(this.attributes, obj);
        }
    }

    public List getChildren() {
        if (this.children == null) {
            return Collections.EMPTY_LIST;
        }
        return this.children;
    }

    public AttributeMap getAttributes() {
        return this.attributes;
    }

    public AttributeMap changeAttributes(AttributeMap change) {
        AttributeMap undo = this.attributes.applyMap(change);
        Object newValue = GraphConstants.getValue(this.attributes);
        if (this.userObject != null && newValue == null) {
            GraphConstants.setValue(this.attributes, this.userObject);
        } else {
            this.setUserObject(newValue);
        }
        Rectangle2D bounds = GraphConstants.getBounds(this.attributes);
        if (bounds == null) {
            GraphConstants.setBounds(this.attributes, defaultBounds);
        }
        return undo;
    }

    public void setAttributes(AttributeMap attributes) {
        this.attributes = attributes;
    }

    public Object clone() {
        DefaultGraphCell c = (DefaultGraphCell)super.clone();
        c.attributes = (AttributeMap)this.attributes.clone();
        c.userObject = this.cloneUserObject();
        return c;
    }

    protected Object cloneUserObject() {
        return this.userObject;
    }
}

