/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.plaf.FontUIResource;
import org.jgraph.JGraph;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultRealEditor;
import org.jgraph.graph.GraphCellEditor;
import org.jgraph.graph.GraphConstants;

public class DefaultGraphCellEditor
implements ActionListener,
GraphCellEditor,
GraphSelectionListener,
Serializable {
    protected GraphCellEditor realEditor;
    protected Container editingContainer;
    protected transient Component editingComponent;
    protected boolean canEdit;
    protected transient int offsetX;
    protected transient int offsetY;
    protected transient JGraph graph;
    protected transient Object lastCell;
    protected Color borderSelectionColor;
    protected transient Icon editingIcon;
    protected Font font;

    public DefaultGraphCellEditor() {
        this(null);
    }

    public DefaultGraphCellEditor(GraphCellEditor editor) {
        this.realEditor = editor;
        if (this.realEditor == null) {
            this.realEditor = this.createGraphCellEditor();
        }
        this.editingContainer = this.createContainer();
        this.setBorderSelectionColor(UIManager.getColor("Tree.editorBorderSelectionColor"));
    }

    public void setBorderSelectionColor(Color newColor) {
        this.borderSelectionColor = newColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public Component getGraphCellEditorComponent(JGraph graph, Object cell, boolean isSelected) {
        this.setGraph(graph);
        this.editingComponent = this.realEditor.getGraphCellEditorComponent(graph, cell, isSelected);
        this.determineOffset(graph, cell, isSelected);
        this.canEdit = this.lastCell != null && cell != null && this.lastCell.equals(cell);
        CellView view = graph.getGraphLayoutCache().getMapping(cell, false);
        if (view != null) {
            this.setFont(GraphConstants.getFont(view.getAllAttributes()));
        }
        this.editingContainer.setFont(this.font);
        return this.editingContainer;
    }

    public Object getCellEditorValue() {
        return this.realEditor.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject event) {
        boolean retValue = false;
        if (!this.realEditor.isCellEditable(event)) {
            return false;
        }
        if (this.canEditImmediately(event)) {
            retValue = true;
        }
        if (retValue) {
            this.prepareForEditing();
        }
        return retValue;
    }

    public boolean shouldSelectCell(EventObject event) {
        return this.realEditor.shouldSelectCell(event);
    }

    public boolean stopCellEditing() {
        if (this.realEditor.stopCellEditing()) {
            if (this.editingComponent != null) {
                this.editingContainer.remove(this.editingComponent);
            }
            this.editingComponent = null;
            return true;
        }
        return false;
    }

    public void cancelCellEditing() {
        this.realEditor.cancelCellEditing();
        if (this.editingComponent != null) {
            this.editingContainer.remove(this.editingComponent);
        }
        this.editingComponent = null;
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.realEditor.addCellEditorListener(l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.realEditor.removeCellEditorListener(l);
    }

    public void valueChanged(GraphSelectionEvent e) {
        if (this.graph != null) {
            this.lastCell = this.graph.getSelectionCount() == 1 ? this.graph.getSelectionCell() : null;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.graph != null) {
            this.graph.startEditingAtCell(this.lastCell);
        }
    }

    protected void setGraph(JGraph newGraph) {
        if (this.graph != newGraph) {
            if (this.graph != null) {
                this.graph.removeGraphSelectionListener(this);
            }
            this.graph = newGraph;
            if (this.graph != null) {
                this.graph.addGraphSelectionListener(this);
            }
        }
    }

    protected boolean shouldStartEditingTimer(EventObject event) {
        if (event instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)event)) {
            MouseEvent me = (MouseEvent)event;
            return me.getClickCount() == 1 && this.inHitRegion(me.getX(), me.getY());
        }
        return false;
    }

    protected boolean canEditImmediately(EventObject event) {
        if (event instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)event)) {
            MouseEvent me = (MouseEvent)event;
            return this.inHitRegion(me.getX(), me.getY());
        }
        return event == null;
    }

    protected boolean inHitRegion(double x, double y) {
        Rectangle2D bounds;
        return this.lastCell == null || this.graph == null || (bounds = this.graph.getCellBounds(this.lastCell)) == null || !(x <= bounds.getX() + (double)this.offsetX) || !(y <= bounds.getY() + (double)this.offsetY) || !((double)this.offsetX < bounds.getWidth() - 5.0);
    }

    protected void determineOffset(JGraph graph, Object value, boolean isSelected) {
        this.editingIcon = null;
        this.offsetX = graph.getHandleSize();
        this.offsetY = graph.getHandleSize();
    }

    protected void prepareForEditing() {
        this.editingContainer.add(this.editingComponent);
    }

    protected Container createContainer() {
        return new EditorContainer();
    }

    protected GraphCellEditor createGraphCellEditor() {
        Border aBorder = UIManager.getBorder("Tree.editorBorder");
        DefaultRealEditor editor = new DefaultRealEditor(new DefaultTextField(aBorder)){

            public boolean shouldSelectCell(EventObject event) {
                boolean retValue = super.shouldSelectCell(event);
                this.getComponent().requestFocus();
                return retValue;
            }
        };
        editor.setClickCountToStart(1);
        return editor;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Vector<Object> values = new Vector<Object>();
        s.defaultWriteObject();
        if (this.realEditor instanceof Serializable) {
            values.addElement("realEditor");
            values.addElement(this.realEditor);
        }
        s.writeObject(values);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Vector values = (Vector)s.readObject();
        int indexCounter = 0;
        int maxCounter = values.size();
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals("realEditor")) {
            this.realEditor = (GraphCellEditor)values.elementAt(++indexCounter);
            ++indexCounter;
        }
    }

    public class DefaultTextField
    extends JTextField {
        protected Border border;

        public DefaultTextField(Border border) {
            this.border = border;
        }

        public Border getBorder() {
            return this.border;
        }

        public Font getFont() {
            Container parent;
            Font font = super.getFont();
            if (font instanceof FontUIResource && (parent = this.getParent()) != null && parent.getFont() != null) {
                font = parent.getFont();
            }
            return font;
        }
    }

    public class EditorContainer
    extends Container {
        public EditorContainer() {
            this.setLayout(null);
        }

        public void paint(Graphics g) {
            Color background;
            Dimension size = this.getSize();
            if (DefaultGraphCellEditor.this.editingIcon != null) {
                int yLoc = 0;
                int xLoc = 0;
                DefaultGraphCellEditor.this.editingIcon.paintIcon(this, g, xLoc, yLoc);
            }
            if ((background = DefaultGraphCellEditor.this.getBorderSelectionColor()) != null) {
                g.setColor(background);
                g.drawRect(0, 0, size.width - 1, size.height - 1);
            }
            super.paint(g);
        }

        public void doLayout() {
            if (DefaultGraphCellEditor.this.editingComponent != null) {
                Dimension cSize = this.getSize();
                int h = (int)DefaultGraphCellEditor.this.editingComponent.getPreferredSize().getHeight();
                int minw = 45;
                int w = (int)DefaultGraphCellEditor.this.editingComponent.getPreferredSize().getWidth() + 5;
                int maxw = (int)DefaultGraphCellEditor.this.editingComponent.getMaximumSize().getWidth();
                w = DefaultGraphCellEditor.this.editingContainer.getParent() != null && maxw > DefaultGraphCellEditor.this.editingContainer.getParent().getWidth() ? cSize.width - DefaultGraphCellEditor.this.offsetX : Math.max(minw, Math.min(w, maxw));
                DefaultGraphCellEditor.this.editingComponent.setBounds(DefaultGraphCellEditor.this.offsetX, DefaultGraphCellEditor.this.offsetY, w, h);
            }
        }

        public Dimension getPreferredSize() {
            if (DefaultGraphCellEditor.this.editingComponent != null) {
                Dimension pSize = DefaultGraphCellEditor.this.editingComponent.getPreferredSize();
                pSize.width += DefaultGraphCellEditor.this.offsetX + 2;
                pSize.height += DefaultGraphCellEditor.this.offsetY + 2;
                int iwidth = 50;
                if (DefaultGraphCellEditor.this.editingIcon != null) {
                    iwidth = Math.max(DefaultGraphCellEditor.this.editingIcon.getIconWidth(), iwidth);
                }
                pSize.height = Math.max(pSize.height, 24);
                pSize.width = Math.max(pSize.width + 5, iwidth);
                return pSize;
            }
            return new Dimension(0, 0);
        }
    }
}

