/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.ParentMap;
import org.jgraph.graph.Port;

public class DefaultGraphModel
extends UndoableEditSupport
implements Serializable,
GraphModel {
    protected transient EventListenerList listenerList = new EventListenerList();
    protected transient Iterator emptyIterator = new EmptyIterator();
    protected List roots = new ArrayList();
    protected boolean asksAllowsChildren = false;
    protected AttributeMap attributes = new AttributeMap();
    static /* synthetic */ Class class$0;

    public int getRootCount() {
        return this.roots.size();
    }

    public Object getRootAt(int index) {
        return this.roots.get(index);
    }

    public int getIndexOfRoot(Object root) {
        return this.roots.indexOf(root);
    }

    public boolean contains(Object node) {
        Object parentNode = null;
        while ((parentNode = this.getParent(node)) != null) {
            node = parentNode;
        }
        return this.roots.contains(node);
    }

    public AttributeMap createAttributes() {
        return new AttributeMap();
    }

    public AttributeMap getAttributes(Object node) {
        if (node instanceof GraphCell) {
            return ((GraphCell)node).getAttributes();
        }
        return this.attributes;
    }

    public Map getAttributes() {
        return this.getAttributes(null);
    }

    public Object getSource(Object edge) {
        if (edge instanceof Edge) {
            return ((Edge)edge).getSource();
        }
        return null;
    }

    public Object getTarget(Object edge) {
        if (edge instanceof Edge) {
            return ((Edge)edge).getTarget();
        }
        return null;
    }

    public boolean acceptsSource(Object edge, Object port) {
        return true;
    }

    public boolean acceptsTarget(Object edge, Object port) {
        return true;
    }

    public Iterator edges(Object port) {
        if (port instanceof Port) {
            return ((Port)port).edges();
        }
        return this.emptyIterator;
    }

    public boolean isEdge(Object edge) {
        return edge instanceof Edge;
    }

    public boolean isPort(Object port) {
        return port instanceof Port;
    }

    public Map cloneCells(Object[] cells) {
        Hashtable<DefaultGraphCell, DefaultGraphCell> map = new Hashtable<DefaultGraphCell, DefaultGraphCell>();
        ArrayList<Object> q = new ArrayList<Object>();
        int i = 0;
        while (i < cells.length) {
            q.add(cells[i]);
            ++i;
        }
        while (!q.isEmpty()) {
            DefaultMutableTreeNode p;
            Object node = q.remove(0);
            if (!(node instanceof DefaultGraphCell)) continue;
            int i2 = 0;
            while (i2 < this.getChildCount(node)) {
                q.add(this.getChild(node, i2));
                ++i2;
            }
            DefaultGraphCell cell = (DefaultGraphCell)node;
            DefaultGraphCell clone = (DefaultGraphCell)cell.clone();
            Object par = this.getParent(cell);
            if (par != null && (p = (DefaultMutableTreeNode)map.get(par)) != null) {
                p.add(clone);
            }
            map.put(cell, clone);
        }
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            Port anchor;
            Object obj = it.next();
            if (!(obj instanceof Port) || (anchor = ((Port)obj).getAnchor()) == null) continue;
            ((Port)obj).setAnchor((Port)map.get(anchor));
        }
        return map;
    }

    public Object getParent(Object child) {
        if (child != null && child instanceof TreeNode) {
            return ((TreeNode)child).getParent();
        }
        return null;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        return ((TreeNode)parent).getIndex((TreeNode)child);
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof TreeNode) {
            return ((TreeNode)parent).getChildAt(index);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent instanceof TreeNode) {
            return ((TreeNode)parent).getChildCount();
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        if (this.asksAllowsChildren && node instanceof TreeNode) {
            return !((TreeNode)node).getAllowsChildren();
        }
        return ((TreeNode)node).isLeaf();
    }

    public void insert(Object[] roots, Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] edits) {
        GraphModelEdit edit = this.createInsertEdit(roots, attributes, cs, pm, edits);
        if (edit != null) {
            edit.execute();
            if (edits != null) {
                int i = 0;
                while (i < edits.length) {
                    if (edits[i] instanceof GraphModelEvent.ExecutableGraphChange) {
                        ((GraphModelEvent.ExecutableGraphChange)((Object)edits[i])).execute();
                    }
                    ++i;
                }
            }
            this.postEdit(edit);
        }
    }

    public void remove(Object[] roots) {
        GraphModelEdit edit = this.createRemoveEdit(roots);
        if (edit != null) {
            edit.execute();
            this.postEdit(edit);
        }
    }

    public void edit(Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] edits) {
        if ((attributes == null || attributes.isEmpty()) && (cs == null || cs.isEmpty()) && pm == null && edits != null && edits.length == 1) {
            if (edits[0] instanceof GraphModelEvent.ExecutableGraphChange) {
                ((GraphModelEvent.ExecutableGraphChange)((Object)edits[0])).execute();
            }
            this.postEdit(edits[0]);
        } else {
            GraphModelEdit edit = this.createCellEdit(attributes, cs, pm, edits);
            if (edit != null) {
                edit.execute();
                if (edits != null) {
                    int i = 0;
                    while (i < edits.length) {
                        if (edits[i] instanceof GraphModelEvent.ExecutableGraphChange) {
                            ((GraphModelEvent.ExecutableGraphChange)((Object)edits[i])).execute();
                        }
                        ++i;
                    }
                }
                this.postEdit(edit);
            }
        }
    }

    public void toBack(Object[] cells) {
        GraphModelLayerEdit edit = this.createLayerEdit(cells, -2);
        if (edit != null) {
            edit.execute();
            this.postEdit(edit);
        }
    }

    public void toFront(Object[] cells) {
        GraphModelLayerEdit edit = this.createLayerEdit(cells, -1);
        if (edit != null) {
            edit.execute();
            this.postEdit(edit);
        }
    }

    protected GraphModelLayerEdit createLayerEdit(Object[] cells, int layer) {
        return new GraphModelLayerEdit(cells, layer);
    }

    protected GraphModelEdit createInsertEdit(Object[] cells, Map attributeMap, ConnectionSet cs, ParentMap pm, UndoableEdit[] edits) {
        GraphModelEdit edit = this.createEdit(cells, null, attributeMap, cs, pm);
        if (edit != null) {
            if (edits != null) {
                int i = 0;
                while (i < edits.length) {
                    edit.addEdit(edits[i]);
                    ++i;
                }
            }
            edit.end();
        }
        return edit;
    }

    protected GraphModelEdit createRemoveEdit(Object[] cells) {
        ParentMap pm;
        ConnectionSet cs = ConnectionSet.create(this, cells, true);
        GraphModelEdit edit = this.createEdit(null, cells, null, cs, pm = ParentMap.create(this, cells, true, false));
        if (edit != null) {
            edit.end();
        }
        return edit;
    }

    protected GraphModelEdit createCellEdit(Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] edits) {
        GraphModelEdit edit = this.createEdit(null, null, attributes, cs, pm);
        if (edit != null) {
            if (edits != null) {
                int i = 0;
                while (i < edits.length) {
                    edit.addEdit(edits[i]);
                    ++i;
                }
            }
            edit.end();
        }
        return edit;
    }

    protected GraphModelEdit createEdit(Object[] inserted, Object[] removed, Map attributes, ConnectionSet cs, ParentMap pm) {
        return new GraphModelEdit(inserted, removed, attributes, cs, pm);
    }

    protected Object[] handleInsert(Object[] cells) {
        Object[] inserted = null;
        if (cells != null) {
            int i = 0;
            while (i < cells.length) {
                if (this.getParent(cells[i]) == null) {
                    this.roots.add(cells[i]);
                }
                ++i;
            }
            inserted = DefaultGraphModel.getDescendants(this, cells).toArray();
        }
        return inserted;
    }

    protected Object[] handleRemove(Object[] cells) {
        ArrayList<Object> removedRoots = new ArrayList<Object>();
        if (cells != null) {
            int i = 0;
            while (i < cells.length) {
                if (this.getParent(cells[i]) == null && this.roots.remove(cells[i])) {
                    removedRoots.add(cells[i]);
                }
                ++i;
            }
        }
        return removedRoots.toArray();
    }

    protected ParentMap handleParentMap(ParentMap parentMap) {
        if (parentMap != null) {
            ParentMap undo = new ParentMap();
            Iterator it = parentMap.entries();
            while (it.hasNext()) {
                ParentMap.Entry entry = (ParentMap.Entry)it.next();
                Object child = entry.getChild();
                Object parent = entry.getParent();
                undo.addEntry(child, this.getParent(child));
                if (parent == null) {
                    if (child instanceof MutableTreeNode) {
                        ((MutableTreeNode)child).removeFromParent();
                    }
                } else if (parent instanceof DefaultMutableTreeNode && child instanceof MutableTreeNode) {
                    ((DefaultMutableTreeNode)parent).add((MutableTreeNode)child);
                }
                boolean isRoot = this.roots.contains(child);
                if (parent == null && !isRoot) {
                    this.roots.add(child);
                    continue;
                }
                if (parent == null || !isRoot) continue;
                this.roots.remove(child);
            }
            return undo;
        }
        return null;
    }

    protected Map handleAttributes(Map attributes) {
        if (attributes != null) {
            Hashtable undo = new Hashtable();
            Iterator it = attributes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object cell = entry.getKey();
                AttributeMap deltaNew = (AttributeMap)entry.getValue();
                if (cell instanceof GraphCell) {
                    AttributeMap deltaOld = ((GraphCell)cell).changeAttributes(deltaNew);
                    undo.put(cell, deltaOld);
                    continue;
                }
                AttributeMap attr = this.getAttributes(cell);
                if (attr == null) continue;
                AttributeMap deltaOld = attr.applyMap(deltaNew);
                undo.put(cell, deltaOld);
            }
            return undo;
        }
        return null;
    }

    protected ConnectionSet handleConnectionSet(ConnectionSet cs) {
        if (cs != null) {
            ConnectionSet csundo = new ConnectionSet();
            Iterator it = cs.connections();
            while (it.hasNext()) {
                ConnectionSet.Connection c = (ConnectionSet.Connection)it.next();
                Object edge = c.getEdge();
                if (c.isSource()) {
                    csundo.connect(edge, this.getSource(edge), true);
                } else {
                    csundo.connect(edge, this.getTarget(edge), false);
                }
                this.handleConnection(c);
            }
            return csundo;
        }
        return null;
    }

    protected void handleConnection(ConnectionSet.Connection c) {
        Object edge = c.getEdge();
        Object old = c.isSource() ? this.getSource(edge) : this.getTarget(edge);
        Object port = c.getPort();
        if (port != old) {
            this.connect(edge, old, c.isSource(), true);
            if (this.contains(port) && this.contains(edge)) {
                this.connect(edge, port, c.isSource(), false);
            }
        }
    }

    protected void connect(Object edge, Object port, boolean isSource, boolean remove) {
        if (port instanceof Port) {
            if (remove) {
                ((Port)port).removeEdge(edge);
            } else {
                ((Port)port).addEdge(edge);
            }
        }
        if (remove) {
            port = null;
        }
        if (edge instanceof Edge) {
            if (isSource) {
                ((Edge)edge).setSource(port);
            } else {
                ((Edge)edge).setTarget(port);
            }
        }
    }

    public void addGraphModelListener(GraphModelListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jgraph.event.GraphModelListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeGraphModelListener(GraphModelListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jgraph.event.GraphModelListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    protected void fireGraphChanged(Object source, GraphModelEvent.GraphModelChange edit) {
        Object[] listeners = this.listenerList.getListenerList();
        GraphModelEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.jgraph.event.GraphModelListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (e == null) {
                    e = new GraphModelEvent(source, edit);
                }
                ((GraphModelListener)listeners[i + 1]).graphChanged(e);
            }
            i -= 2;
        }
    }

    public GraphModelListener[] getGraphModelListeners() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jgraph.event.GraphModelListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (GraphModelListener[])this.listenerList.getListeners(clazz);
    }

    public static Object getSourceVertex(GraphModel model, Object edge) {
        if (model != null) {
            return model.getParent(model.getSource(edge));
        }
        return null;
    }

    public static Object getTargetVertex(GraphModel model, Object edge) {
        if (model != null) {
            return model.getParent(model.getTarget(edge));
        }
        return null;
    }

    public static Object[] getRoots(GraphModel model) {
        Object[] cells = null;
        if (model != null) {
            cells = new Object[model.getRootCount()];
            int i = 0;
            while (i < cells.length) {
                cells[i] = model.getRootAt(i);
                ++i;
            }
        }
        return cells;
    }

    public static Set getEdges(GraphModel model, Object[] cells) {
        HashSet result = new HashSet();
        Set allCells = DefaultGraphModel.getDescendants(model, cells);
        if (allCells != null) {
            Iterator it = allCells.iterator();
            while (it.hasNext()) {
                Iterator edges = model.edges(it.next());
                while (edges.hasNext()) {
                    result.add(edges.next());
                }
            }
            result.removeAll(allCells);
        }
        return result;
    }

    public static Set getDescendants(GraphModel model, Object[] cells) {
        if (cells != null) {
            Stack<Object> stack = new Stack<Object>();
            int i = 0;
            while (i < cells.length) {
                stack.add(cells[i]);
                ++i;
            }
            HashSet result = new HashSet();
            while (!stack.isEmpty()) {
                Object tmp = stack.pop();
                int i2 = 0;
                while (i2 < model.getChildCount(tmp)) {
                    stack.add(model.getChild(tmp, i2));
                    ++i2;
                }
                if (tmp == null) continue;
                result.add(tmp);
            }
            return result;
        }
        return null;
    }

    public static List getDescendantList(GraphModel model, Object[] cells) {
        if (cells != null) {
            Stack<Object> stack = new Stack<Object>();
            int i = cells.length - 1;
            while (i >= 0) {
                stack.add(cells[i]);
                --i;
            }
            LinkedList result = new LinkedList();
            while (!stack.isEmpty()) {
                Object tmp = stack.pop();
                int i2 = model.getChildCount(tmp) - 1;
                while (i2 >= 0) {
                    stack.add(model.getChild(tmp, i2));
                    --i2;
                }
                if (tmp == null) continue;
                result.add(tmp);
            }
            return result;
        }
        return null;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.listenerList = new EventListenerList();
        this.emptyIterator = new EmptyIterator();
    }

    public class GraphModelEdit
    extends CompoundEdit
    implements GraphModelEvent.GraphModelChange,
    GraphModelEvent.ExecutableGraphChange {
        protected Object[] insert;
        protected Object[] changed;
        protected Object[] remove;
        protected Object[] context;
        protected Object[] inserted;
        protected Object[] removed;
        protected Map attributes;
        protected Map previousAttributes;
        protected ParentMap parentMap;
        protected ParentMap previousParentMap;
        protected ConnectionSet connectionSet;
        protected ConnectionSet previousConnectionSet;
        protected Map cellViews = new Hashtable();

        public GraphModelEdit(Object[] inserted, Object[] removed, Map attributes, ConnectionSet connectionSet, ParentMap parentMap) {
            this.insert = inserted;
            this.remove = removed;
            this.connectionSet = connectionSet;
            this.attributes = attributes;
            this.parentMap = parentMap;
            this.previousAttributes = attributes;
            this.previousConnectionSet = connectionSet;
            this.previousParentMap = parentMap;
            if (parentMap != null) {
                Hashtable childCount = new Hashtable();
                Iterator it = parentMap.entries();
                while (it.hasNext()) {
                    Object newParent;
                    Object oldParent;
                    ParentMap.Entry entry = (ParentMap.Entry)it.next();
                    Object child = entry.getChild();
                    if (DefaultGraphModel.this.isPort(child) || (oldParent = DefaultGraphModel.this.getParent(child)) == (newParent = entry.getParent())) continue;
                    this.changeChildCount(childCount, oldParent, -1);
                    this.changeChildCount(childCount, newParent, 1);
                }
                this.handleEmptyGroups(this.filterParents(childCount, 0));
            }
        }

        public Object[] filterParents(Map childCount, int children) {
            ArrayList list = new ArrayList();
            Iterator it = childCount.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!(entry.getValue() instanceof Integer) || (Integer)entry.getValue() != children) continue;
                list.add(entry.getKey());
            }
            return list.toArray();
        }

        protected void changeChildCount(Map childCount, Object parent, int change) {
            if (parent != null) {
                Integer count = (Integer)childCount.get(parent);
                if (count == null) {
                    count = new Integer(DefaultGraphModel.this.getChildCount(parent));
                }
                int newValue = count + change;
                childCount.put(parent, new Integer(newValue));
            }
        }

        protected void handleEmptyGroups(Object[] groups) {
            if (groups != null && groups.length > 0) {
                if (this.remove == null) {
                    this.remove = new Object[0];
                }
                Object[] tmp = new Object[this.remove.length + groups.length];
                System.arraycopy(this.remove, 0, tmp, 0, this.remove.length);
                System.arraycopy(groups, 0, tmp, this.remove.length, groups.length);
                this.remove = tmp;
            }
        }

        public boolean isSignificant() {
            return true;
        }

        public Object getSource() {
            return DefaultGraphModel.this;
        }

        public Object[] getChanged() {
            return this.changed;
        }

        public Object[] getContext() {
            return this.context;
        }

        public Object[] getInserted() {
            return this.inserted;
        }

        public Object[] getRemoved() {
            return this.removed;
        }

        public Map getPreviousAttributes() {
            return this.previousAttributes;
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public ConnectionSet getConnectionSet() {
            return this.connectionSet;
        }

        public ConnectionSet getPreviousConnectionSet() {
            return this.previousConnectionSet;
        }

        public ParentMap getParentMap() {
            return this.parentMap;
        }

        public ParentMap getPreviousParentMap() {
            return this.previousParentMap;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.execute();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        public void execute() {
            HashSet tmp = new HashSet();
            if (this.attributes != null) {
                tmp.addAll(this.attributes.keySet());
            }
            if (this.parentMap != null) {
                tmp.addAll(this.parentMap.getChangedNodes());
            }
            if (this.connectionSet != null) {
                tmp.addAll(this.connectionSet.getChangedEdges());
            }
            if (this.remove != null) {
                int i = 0;
                while (i < this.remove.length) {
                    tmp.remove(this.remove[i]);
                    ++i;
                }
            }
            this.changed = tmp.toArray();
            Set ctx = DefaultGraphModel.getEdges(DefaultGraphModel.this, this.changed);
            this.context = ctx.toArray();
            this.inserted = this.insert;
            this.removed = this.remove;
            this.remove = DefaultGraphModel.this.handleInsert(this.inserted);
            this.previousParentMap = this.parentMap;
            this.parentMap = DefaultGraphModel.this.handleParentMap(this.parentMap);
            if (this.parentMap != null) {
                tmp.addAll(this.parentMap.getChangedNodes());
            }
            this.previousConnectionSet = this.connectionSet;
            this.connectionSet = DefaultGraphModel.this.handleConnectionSet(this.connectionSet);
            this.insert = DefaultGraphModel.this.handleRemove(this.removed);
            this.previousAttributes = this.attributes;
            this.attributes = DefaultGraphModel.this.handleAttributes(this.attributes);
            this.changed = tmp.toArray();
            DefaultGraphModel.this.fireGraphChanged(DefaultGraphModel.this, this);
        }

        public void putViews(GraphLayoutCache view, CellView[] views) {
            if (view != null && views != null) {
                this.cellViews.put(view, views);
            }
        }

        public CellView[] getViews(GraphLayoutCache view) {
            return (CellView[])this.cellViews.get(view);
        }

        public String toString() {
            int i;
            String s = new String();
            if (this.inserted != null) {
                s = String.valueOf(s) + "Inserted:\n";
                i = 0;
                while (i < this.inserted.length) {
                    s = String.valueOf(s) + "  " + this.inserted[i] + "\n";
                    ++i;
                }
            } else {
                s = String.valueOf(s) + "None inserted\n";
            }
            if (this.removed != null) {
                s = String.valueOf(s) + "Removed:\n";
                i = 0;
                while (i < this.removed.length) {
                    s = String.valueOf(s) + "  " + this.removed[i] + "\n";
                    ++i;
                }
            } else {
                s = String.valueOf(s) + "None removed\n";
            }
            if (this.changed != null && this.changed.length > 0) {
                s = String.valueOf(s) + "Changed:\n";
                i = 0;
                while (i < this.changed.length) {
                    s = String.valueOf(s) + "  " + this.changed[i] + "\n";
                    ++i;
                }
            } else {
                s = String.valueOf(s) + "None changed\n";
            }
            s = this.parentMap != null ? String.valueOf(s) + this.parentMap.toString() : String.valueOf(s) + "No parent map\n";
            return s;
        }
    }

    public class GraphModelLayerEdit
    extends GraphLayoutCache.GraphViewLayerEdit
    implements GraphModelEvent.GraphModelChange {
        protected Object[] parents;

        public GraphModelLayerEdit(Object[] cells, int layer) {
            super(DefaultGraphModel.this, cells, layer);
            HashSet<TreeNode> par = new HashSet<TreeNode>();
            int i = 0;
            while (i < cells.length) {
                if (cells[i] instanceof TreeNode) {
                    par.add(((TreeNode)cells[i]).getParent());
                }
                ++i;
            }
            this.parents = par.toArray();
        }

        public Object getSource() {
            return DefaultGraphModel.this;
        }

        public Object[] getChanged() {
            return this.parents;
        }

        public Object[] getInserted() {
            return null;
        }

        public Object[] getRemoved() {
            return null;
        }

        public Map getPreviousAttributes() {
            return null;
        }

        public ConnectionSet getPreviousConnectionSet() {
            return null;
        }

        public ParentMap getPreviousParentMap() {
            return null;
        }

        public void addImplicitEdit(UndoableEdit edit) {
        }

        public CellView[] getViews(GraphLayoutCache view) {
            return null;
        }

        public void putViews(GraphLayoutCache view, CellView[] cellViews) {
        }

        protected void updateListeners() {
            DefaultGraphModel.this.fireGraphChanged(DefaultGraphModel.this, this);
        }

        protected List getParentList(Object cell) {
            List list = null;
            if (cell instanceof DefaultMutableTreeNode) {
                TreeNode parent = ((DefaultMutableTreeNode)cell).getParent();
                list = parent instanceof DefaultGraphCell ? ((DefaultGraphCell)parent).getChildren() : DefaultGraphModel.this.roots;
            }
            return list;
        }
    }

    public static class EmptyIterator
    implements Iterator,
    Serializable {
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    }
}

