/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import org.jgraph.JGraph;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphSelectionModel;

public class DefaultGraphSelectionModel
implements GraphSelectionModel,
Cloneable,
Serializable {
    public static final String SELECTION_MODE_PROPERTY = "selectionMode";
    public static final int SELECTED = -1;
    public static final Integer UNSELECTED = new Integer(0);
    protected JGraph graph;
    protected SwingPropertyChangeSupport changeSupport;
    protected EventListenerList listenerList = new EventListenerList();
    protected int selectionMode;
    protected boolean childrenSelectable = true;
    protected Map cellStates = new Hashtable();
    protected List selection = new ArrayList();
    static /* synthetic */ Class class$0;

    public DefaultGraphSelectionModel(JGraph graph) {
        this.graph = graph;
    }

    public void setSelectionMode(int mode) {
        int oldMode = this.selectionMode;
        this.selectionMode = mode;
        if (this.selectionMode != 4 && this.selectionMode != 1) {
            this.selectionMode = 4;
        }
        if (oldMode != this.selectionMode && this.changeSupport != null) {
            this.changeSupport.firePropertyChange(SELECTION_MODE_PROPERTY, new Integer(oldMode), new Integer(this.selectionMode));
        }
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setChildrenSelectable(boolean flag) {
        this.childrenSelectable = flag;
    }

    public boolean isChildrenSelectable() {
        return this.childrenSelectable;
    }

    protected boolean isChildrenSelectable(Object cell) {
        return this.childrenSelectable;
    }

    public void setSelectionCell(Object cell) {
        if (cell == null) {
            this.setSelectionCells(null);
        } else {
            this.setSelectionCells(new Object[]{cell});
        }
    }

    public void setSelectionCells(Object[] cells) {
        if (cells != null) {
            if (this.selectionMode == 1 && cells.length > 0) {
                cells = new Object[]{cells[cells.length - 1]};
            }
            this.cellStates.clear();
            Vector<CellPlaceHolder> change = new Vector<CellPlaceHolder>();
            ArrayList newSelection = new ArrayList();
            int i = 0;
            while (i < cells.length) {
                if (cells[i] != null) {
                    this.selection.remove(cells[i]);
                    change.addElement(new CellPlaceHolder(cells[i], !this.selection.remove(cells[i])));
                    this.select(newSelection, cells[i]);
                    Object parent = this.graph.getModel().getParent(cells[i]);
                    if (parent != null) {
                        change.addElement(new CellPlaceHolder(parent, false));
                    }
                }
                ++i;
            }
            Iterator it = this.selection.iterator();
            while (it.hasNext()) {
                Object cell = it.next();
                while (cell != null) {
                    change.addElement(new CellPlaceHolder(cell, false));
                    cell = this.graph.getModel().getParent(cell);
                }
            }
            this.selection = newSelection;
            if (change.size() > 0) {
                this.notifyCellChange(change);
            }
        }
    }

    public void addSelectionCell(Object cell) {
        if (cell != null) {
            this.addSelectionCells(new Object[]{cell});
        }
    }

    public void addSelectionCells(Object[] cells) {
        if (cells != null) {
            if (this.selectionMode == 1) {
                this.setSelectionCells(cells);
            } else {
                Vector<CellPlaceHolder> change = new Vector<CellPlaceHolder>();
                int i = 0;
                while (i < cells.length) {
                    boolean newness;
                    if (cells[i] != null && (newness = this.select(this.selection, cells[i]))) {
                        change.addElement(new CellPlaceHolder(cells[i], true));
                        Object parent = this.graph.getModel().getParent(cells[i]);
                        if (parent != null) {
                            change.addElement(new CellPlaceHolder(parent, false));
                        }
                    }
                    ++i;
                }
                if (change.size() > 0) {
                    this.notifyCellChange(change);
                }
            }
        }
    }

    public void removeSelectionCell(Object cell) {
        if (cell != null) {
            this.removeSelectionCells(new Object[]{cell});
        }
    }

    public void removeSelectionCells(Object[] cells) {
        if (cells != null) {
            Vector<CellPlaceHolder> change = new Vector<CellPlaceHolder>();
            int i = 0;
            while (i < cells.length) {
                boolean removed;
                if (cells[i] != null && (removed = this.deselect(cells[i]))) {
                    change.addElement(new CellPlaceHolder(cells[i], false));
                    Object parent = this.graph.getModel().getParent(cells[i]);
                    if (parent != null) {
                        change.addElement(new CellPlaceHolder(parent, false));
                    }
                }
                ++i;
            }
            if (change.size() > 0) {
                this.notifyCellChange(change);
            }
        }
    }

    public Object[] getSelectables() {
        if (this.isChildrenSelectable()) {
            ArrayList result = new ArrayList();
            Stack<Object> s = new Stack<Object>();
            Object[] cells = this.graph.getGraphLayoutCache().getCells(this.graph.getGraphLayoutCache().getRoots());
            int i = 0;
            while (i < cells.length) {
                s.add(cells[i]);
                ++i;
            }
            GraphModel model = this.graph.getModel();
            while (!s.isEmpty()) {
                Object cell = s.pop();
                if (!model.isPort(cell)) {
                    result.add(cell);
                }
                if (!this.isChildrenSelectable(cell) || this.getSelectedChildCount(cell) == 0) continue;
                int i2 = 0;
                while (i2 < model.getChildCount(cell)) {
                    s.add(model.getChild(cell, i2));
                    ++i2;
                }
            }
            return result.toArray();
        }
        return this.graph.getRoots();
    }

    public Object getSelectionCell() {
        if (this.selection != null && this.selection.size() > 0) {
            return this.selection.toArray()[0];
        }
        return null;
    }

    public Object[] getSelectionCells() {
        if (this.selection != null) {
            return this.selection.toArray();
        }
        return null;
    }

    public int getSelectionCount() {
        return this.selection == null ? 0 : this.selection.size();
    }

    public boolean isCellSelected(Object cell) {
        int count = this.getSelectedChildCount(cell);
        return count == -1;
    }

    public boolean isChildrenSelected(Object cell) {
        int count = this.getSelectedChildCount(cell);
        return count > 0;
    }

    public boolean isSelectionEmpty() {
        return this.selection.isEmpty();
    }

    public void clearSelection() {
        if (this.selection != null) {
            Vector<CellPlaceHolder> change = new Vector<CellPlaceHolder>();
            Iterator it = this.cellStates.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object cell = entry.getKey();
                while (cell != null) {
                    change.addElement(new CellPlaceHolder(cell, false));
                    cell = this.graph.getModel().getParent(cell);
                }
            }
            this.selection.clear();
            this.cellStates.clear();
            if (change.size() > 0) {
                this.notifyCellChange(change);
            }
        }
    }

    protected int getSelectedChildCount(Object cell) {
        if (cell != null) {
            Integer state = (Integer)this.cellStates.get(cell);
            if (state == null) {
                state = UNSELECTED;
                this.cellStates.put(cell, state);
            }
            return state;
        }
        return 0;
    }

    protected void setSelectedChildCount(Object cell, int count) {
        Integer i = new Integer(count);
        this.cellStates.put(cell, i);
    }

    protected boolean select(List list, Object cell) {
        if (!this.isCellSelected(cell) && this.graph.getGraphLayoutCache().isVisible(cell)) {
            GraphModel model = this.graph.getModel();
            Object parent = model.getParent(cell);
            while (parent != null) {
                int count = this.getSelectedChildCount(parent);
                if (count == -1) {
                    count = 0;
                }
                this.setSelectedChildCount(parent, ++count);
                this.selection.remove(parent);
                parent = model.getParent(parent);
            }
            Object[] tmp = new Object[]{cell};
            Set childs = DefaultGraphModel.getDescendants(model, tmp);
            childs.remove(cell);
            Iterator it = childs.iterator();
            while (it.hasNext()) {
                Object child = it.next();
                if (child == null || model.isPort(child)) continue;
                this.selection.remove(child);
                this.cellStates.remove(child);
            }
            this.setSelectedChildCount(cell, -1);
            return list.add(cell);
        }
        return false;
    }

    protected boolean deselect(Object cell) {
        if (this.isCellSelected(cell)) {
            Object parent = this.graph.getModel().getParent(cell);
            boolean firstParent = true;
            int change = -1;
            while (parent != null && change != 0) {
                int count = this.getSelectedChildCount(parent);
                if ((count += change) == 0 && firstParent) {
                    change = 0;
                    count = -1;
                    this.selection.add(parent);
                }
                this.setSelectedChildCount(parent, count);
                parent = this.graph.getModel().getParent(parent);
                firstParent = false;
            }
            this.cellStates.remove(cell);
            return this.selection.remove(cell);
        }
        return false;
    }

    public void addGraphSelectionListener(GraphSelectionListener x) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jgraph.event.GraphSelectionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, x);
    }

    public void removeGraphSelectionListener(GraphSelectionListener x) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jgraph.event.GraphSelectionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, x);
    }

    protected void fireValueChanged(GraphSelectionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.jgraph.event.GraphSelectionListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                ((GraphSelectionListener)listeners[i + 1]).valueChanged(e);
            }
            i -= 2;
        }
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    protected void notifyCellChange(Vector changedCells) {
        int cCellCount = changedCells.size();
        boolean[] newness = new boolean[cCellCount];
        Object[] cells = new Object[cCellCount];
        int counter = 0;
        while (counter < cCellCount) {
            CellPlaceHolder placeholder = (CellPlaceHolder)changedCells.elementAt(counter);
            newness[counter] = placeholder.isNew;
            cells[counter] = placeholder.cell;
            ++counter;
        }
        GraphSelectionEvent event = new GraphSelectionEvent(this, cells, newness);
        this.fireValueChanged(event);
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultGraphSelectionModel clone = (DefaultGraphSelectionModel)super.clone();
        clone.changeSupport = null;
        if (this.selection != null) {
            clone.selection = new ArrayList(this.selection);
        }
        clone.listenerList = new EventListenerList();
        return clone;
    }

    protected class CellPlaceHolder {
        protected boolean isNew;
        protected Object cell;

        protected CellPlaceHolder(Object cell, boolean isNew) {
            this.cell = cell;
            this.isNew = isNew;
        }

        public Object getCell() {
            return this.cell;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public void setCell(Object cell) {
            this.cell = cell;
        }

        public void setNew(boolean isNew) {
            this.isNew = isNew;
        }
    }
}

