/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.util.Bezier;
import org.jgraph.util.Spline2D;

public class EdgeRenderer
extends JComponent
implements CellViewRenderer,
Serializable {
    protected transient Graphics fontGraphics = new BufferedImage(1, 1, 1).getGraphics();
    protected transient FontMetrics metrics;
    protected transient JGraph graph;
    protected transient EdgeView view;
    protected transient int beginDeco;
    protected transient int endDeco;
    protected transient int beginSize;
    protected transient int endSize;
    protected transient int lineStyle;
    protected transient float lineWidth;
    protected transient boolean labelBorder;
    protected transient boolean beginFill;
    protected transient boolean endFill;
    protected transient boolean focus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient boolean labelTransformEnabled;
    protected transient Color borderColor;
    protected transient Color defaultForeground = UIManager.getColor("Tree.textForeground");
    protected transient Color defaultBackground = UIManager.getColor("Tree.textBackground");
    protected transient Color fontColor;
    protected transient float[] lineDash;
    protected Bezier bezier;
    protected Spline2D spline;

    void setView(CellView value) {
        if (value instanceof EdgeView) {
            this.view = (EdgeView)value;
            this.installAttributes(this.view);
        } else {
            this.view = null;
        }
    }

    public Component getRendererComponent(JGraph graph, CellView view, boolean sel, boolean focus, boolean preview) {
        if (view instanceof EdgeView && graph != null) {
            this.graph = graph;
            this.focus = focus;
            this.selected = sel;
            this.preview = preview;
            this.setView(view);
            return this;
        }
        return null;
    }

    public boolean intersects(Graphics g, CellView value, Rectangle r) {
        if (value instanceof EdgeView && g != null && value != null) {
            this.setView(value);
            Graphics2D g2 = (Graphics2D)g;
            boolean hit = g2.hit(r, this.view.getShape(), true);
            if (hit) {
                return true;
            }
            Rectangle2D rect = this.getLabelBounds(this.view);
            if (rect != null) {
                return rect.intersects(r);
            }
        }
        return false;
    }

    public Rectangle2D getBounds(CellView value) {
        if (value instanceof EdgeView && value != null) {
            this.setView(value);
            Rectangle2D r = this.getPaintBounds(this.view);
            Rectangle2D label = this.getLabelBounds(this.view);
            if (label != null) {
                Rectangle2D.union(r, label, r);
            }
            int b = (int)Math.ceil(this.lineWidth);
            r.setFrame(r.getX() - (double)b, r.getY() - (double)b, r.getWidth() + (double)(2 * b), r.getHeight() + (double)(2 * b));
            return r;
        }
        return null;
    }

    private boolean isLabelTransformEnabled() {
        return this.labelTransformEnabled;
    }

    private boolean isLabelTransform(String label) {
        if (!this.isLabelTransformEnabled()) {
            return false;
        }
        Point2D p = this.getLabelPosition(this.view);
        if (p != null && label != null && label.length() > 0) {
            int sw = this.metrics.stringWidth(label);
            if (this.view.getPointCount() == 2) {
                Point2D p1 = this.view.getPoint(0);
                Point2D p2 = this.view.getPoint(1);
                double length = Math.sqrt((p2.getX() - p1.getX()) * (p2.getX() - p1.getX()) + (p2.getY() - p1.getY()) * (p2.getY() - p1.getY()));
                if (!(length <= Double.NaN) && !(length < (double)sw)) {
                    return true;
                }
            }
        }
        return false;
    }

    private double getLabelAngle(String label) {
        Point2D p = this.getLabelPosition(this.view);
        double angle = 0.0;
        if (p != null && label != null && label.length() > 0) {
            int sw = this.metrics.stringWidth(label);
            if (this.view.getPointCount() == 2) {
                Point2D p1 = this.view.getPoint(0);
                Point2D p2 = this.view.getPoint(1);
                double length = Math.sqrt((p2.getX() - p1.getX()) * (p2.getX() - p1.getX()) + (p2.getY() - p1.getY()) * (p2.getY() - p1.getY()));
                if (!(length <= Double.NaN) && !(length < (double)sw)) {
                    double cos = (p2.getX() - p1.getX()) / length;
                    double sin = (p2.getY() - p1.getY()) / length;
                    angle = Math.acos(cos);
                    if (sin < 0.0) {
                        angle = Math.PI * 2 - angle;
                    }
                }
            }
            if (angle > 1.5707963267948966 && angle <= 4.71238898038469) {
                angle -= Math.PI;
            }
        }
        return angle;
    }

    public Rectangle2D getLabelBounds(EdgeView view) {
        String label;
        this.setView(view);
        Point2D p = this.getLabelPosition(this.view);
        Dimension d = this.getLabelSize(this.view);
        String labelObj = this.graph != null ? this.graph.convertValueToString(view) : null;
        String string = label = labelObj != null ? labelObj.toString() : null;
        if (label != null && this.isLabelTransform(label)) {
            double angle = this.getLabelAngle(label);
            if (angle < 0.0) {
                angle = -angle;
            }
            if (angle > 1.5707963267948966) {
                angle %= 1.5707963267948966;
            }
            double yside = Math.abs(Math.cos(angle) * (double)d.height + Math.sin(angle) * (double)d.width);
            double xside = Math.abs((double)d.width * Math.cos(angle) + (double)d.height * Math.sin(angle));
            if (xside > yside) {
                yside = xside;
            }
            if (yside > xside) {
                xside = yside;
            }
            angle = this.getLabelAngle(label);
            d.width = (int)xside + d.height;
            d.height = (int)yside + d.height;
        }
        if (p != null && d != null) {
            return view.getAttributes().createRect(p.getX() - (double)(d.width / 2), p.getY() - (double)(d.height / 2), d.width + 1, d.height + 1);
        }
        return null;
    }

    public Point2D getLabelPosition(EdgeView view) {
        this.setView(view);
        Rectangle2D tmp = this.getPaintBounds(view);
        Point2D pos = view.getLabelPosition();
        int unit = 1000;
        Point2D p0 = view.getPoint(0);
        Point2D pe = view.getPoint(view.getPointCount() - 1);
        if (pos != null && tmp != null) {
            double x0 = tmp.getX();
            int xdir = 1;
            if (p0.getX() > pe.getX()) {
                x0 += tmp.getWidth();
                xdir = -1;
            }
            double y0 = tmp.getY();
            int ydir = 1;
            if (p0.getY() > pe.getY()) {
                y0 += tmp.getHeight();
                ydir = -1;
            }
            double x = x0 + (double)xdir * (tmp.getWidth() * pos.getX() / (double)unit);
            double y = y0 + (double)ydir * (tmp.getHeight() * pos.getY() / (double)unit);
            return view.getAttributes().createPoint(x, y);
        }
        return null;
    }

    public Dimension getLabelSize(EdgeView view) {
        this.setView(view);
        String label = view.getGraph().convertValueToString(view);
        if (label != null && label.toString().length() > 0) {
            this.fontGraphics.setFont(GraphConstants.getFont(view.getAllAttributes()));
            this.metrics = this.fontGraphics.getFontMetrics();
            int sw = this.metrics.stringWidth(label.toString());
            int sh = this.metrics.getHeight();
            return new Dimension(sw, sh);
        }
        return null;
    }

    protected void installAttributes(CellView view) {
        AttributeMap map = view.getAllAttributes();
        this.beginDeco = GraphConstants.getLineBegin(map);
        this.beginSize = GraphConstants.getBeginSize(map);
        this.beginFill = GraphConstants.isBeginFill(map) && this.isFillable(this.beginDeco);
        this.endDeco = GraphConstants.getLineEnd(map);
        this.endSize = GraphConstants.getEndSize(map);
        this.endFill = GraphConstants.isEndFill(map) && this.isFillable(this.endDeco);
        this.lineWidth = GraphConstants.getLineWidth(map);
        this.lineStyle = GraphConstants.getLineStyle(map);
        this.lineDash = GraphConstants.getDashPattern(map);
        this.borderColor = GraphConstants.getBorderColor(map);
        Color foreground = GraphConstants.getLineColor(map);
        this.setForeground(foreground != null ? foreground : this.defaultForeground);
        Color background = GraphConstants.getBackground(map);
        this.setBackground(background != null ? background : this.defaultBackground);
        this.setOpaque(GraphConstants.isOpaque(map));
        this.setFont(GraphConstants.getFont(map));
        Color tmp = GraphConstants.getForeground(map);
        this.fontColor = tmp != null ? tmp : this.getForeground();
        this.fontGraphics.setFont(this.getFont());
        this.metrics = this.fontGraphics.getFontMetrics();
        this.labelTransformEnabled = GraphConstants.isLabelAlongEdge(map);
    }

    protected boolean isFillable(int decoration) {
        return decoration != 4 && decoration != 7 && decoration != 8;
    }

    public Rectangle2D getPaintBounds(EdgeView view) {
        this.setView(view);
        return view.getShape().getBounds();
    }

    public void paint(Graphics g) {
        Shape edgeShape = this.view.getShape();
        if (edgeShape != null) {
            String label;
            Graphics2D g2 = (Graphics2D)g;
            int c = 0;
            int j = 0;
            g2.setStroke(new BasicStroke(this.lineWidth, c, j));
            this.translateGraphics(g);
            g.setColor(this.getForeground());
            if (this.view.beginShape != null) {
                if (this.beginFill) {
                    g2.fill(this.view.beginShape);
                }
                g2.draw(this.view.beginShape);
            }
            if (this.view.endShape != null) {
                if (this.endFill) {
                    g2.fill(this.view.endShape);
                }
                g2.draw(this.view.endShape);
            }
            if (this.lineDash != null) {
                g2.setStroke(new BasicStroke(this.lineWidth, c, j, 10.0f, this.lineDash, 0.0f));
            }
            if (this.view.lineShape != null) {
                g2.draw(this.view.lineShape);
            }
            if (this.selected) {
                g2.setStroke(GraphConstants.SELECTION_STROKE);
                g2.setColor(this.graph.getHighlightColor());
                if (this.view.beginShape != null) {
                    g2.draw(this.view.beginShape);
                }
                if (this.view.lineShape != null) {
                    g2.draw(this.view.lineShape);
                }
                if (this.view.endShape != null) {
                    g2.draw(this.view.endShape);
                }
            }
            if (this.graph.getEditingCell() != this.view.getCell() && (label = this.graph.convertValueToString(this.view)) != null) {
                g2.setStroke(new BasicStroke(1.0f));
                g.setFont(this.getFont());
                this.paintLabel(g, label.toString());
            }
        }
    }

    protected void translateGraphics(Graphics g) {
        g.translate(-this.getX(), -this.getY());
    }

    protected void paintLabel(Graphics g, String label) {
        Point2D p = this.getLabelPosition(this.view);
        if (p != null && label != null && label.length() > 0) {
            int sw = this.metrics.stringWidth(label);
            int sh = this.metrics.getHeight();
            Graphics2D g2 = (Graphics2D)g;
            boolean applyTransform = this.isLabelTransform(label);
            double angle = 0.0;
            g2.translate(p.getX(), p.getY());
            if (applyTransform) {
                angle = this.getLabelAngle(label);
                g2.rotate(angle);
            }
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(-sw / 2 - 1, -sh / 2 - 1, sw + 2, sh + 2);
            }
            if (this.borderColor != null) {
                g.setColor(this.borderColor);
                g.drawRect(-sw / 2 - 1, -sh / 2 - 1, sw + 2, sh + 2);
            }
            g.setColor(this.fontColor);
            int dx = -sw / 2;
            int dy = sh / 4;
            if (applyTransform && this.borderColor == null && !this.isOpaque()) {
                dy = -this.metrics.getDescent();
            }
            g.drawString(label, dx, dy);
            if (applyTransform) {
                g2.rotate(-angle);
            }
            g2.translate(-p.getX(), -p.getY());
        }
    }

    protected Shape createShape() {
        int n = this.view.getPointCount();
        if (n > 1) {
            EdgeView tmp = this.view;
            Point2D[] p = new Point2D[n];
            int i = 0;
            while (i < n) {
                p[i] = tmp.getAttributes().createPoint(tmp.getPoint(i));
                ++i;
            }
            if (this.view != tmp) {
                this.view = tmp;
                this.installAttributes(this.view);
            }
            if (this.view.sharedPath == null) {
                this.view.sharedPath = new GeneralPath(1);
            } else {
                this.view.sharedPath.reset();
            }
            this.view.endShape = null;
            this.view.lineShape = null;
            this.view.beginShape = null;
            Point2D p0 = p[0];
            Point2D pe = p[n - 1];
            Point2D p1 = p[1];
            Point2D p2 = p[n - 2];
            if (this.lineStyle == 12 && n > 2) {
                this.bezier = new Bezier(p);
                p2 = this.bezier.getPoint(this.bezier.getPointCount() - 1);
            } else if (this.lineStyle == 13 && n > 2) {
                this.spline = new Spline2D(p);
                double[] point = this.spline.getPoint(0.99);
                p2.setLocation(point[0], point[1]);
            }
            if (this.beginDeco != 0) {
                this.view.beginShape = this.createLineEnd(this.beginSize, this.beginDeco, p1, p0);
            }
            if (this.endDeco != 0) {
                this.view.endShape = this.createLineEnd(this.endSize, this.endDeco, p2, pe);
            }
            this.view.sharedPath.moveTo((float)p0.getX(), (float)p0.getY());
            if (this.lineStyle == 12 && n > 2) {
                Point2D[] b = this.bezier.getPoints();
                this.view.sharedPath.quadTo((float)b[0].getX(), (float)b[0].getY(), (float)p1.getX(), (float)p1.getY());
                int i2 = 2;
                while (i2 < n - 1) {
                    Point2D b0 = b[2 * i2 - 3];
                    Point2D b1 = b[2 * i2 - 2];
                    this.view.sharedPath.curveTo((float)b0.getX(), (float)b0.getY(), (float)b1.getX(), (float)b1.getY(), (float)p[i2].getX(), (float)p[i2].getY());
                    ++i2;
                }
                this.view.sharedPath.quadTo((float)b[b.length - 1].getX(), (float)b[b.length - 1].getY(), (float)p[n - 1].getX(), (float)p[n - 1].getY());
            } else if (this.lineStyle == 13 && n > 2) {
                double t = 0.0;
                while (t <= 1.0) {
                    double[] xy = this.spline.getPoint(t);
                    this.view.sharedPath.lineTo((float)xy[0], (float)xy[1]);
                    t += 0.01;
                }
            } else {
                int i3 = 1;
                while (i3 < n - 1) {
                    this.view.sharedPath.lineTo((float)p[i3].getX(), (float)p[i3].getY());
                    ++i3;
                }
                this.view.sharedPath.lineTo((float)pe.getX(), (float)pe.getY());
            }
            this.view.sharedPath.moveTo((float)pe.getX(), (float)pe.getY());
            this.view.lineShape = (GeneralPath)this.view.sharedPath.clone();
            if (this.view.endShape != null) {
                this.view.sharedPath.append(this.view.endShape, true);
            }
            if (this.view.beginShape != null) {
                this.view.sharedPath.append(this.view.beginShape, true);
            }
            return this.view.sharedPath;
        }
        return null;
    }

    protected Shape createLineEnd(int size, int style, Point2D src, Point2D dst) {
        int d = (int)Math.max(1.0, dst.distance(src));
        int ax = (int)(-((double)size * (dst.getX() - src.getX()) / (double)d));
        int ay = (int)(-((double)size * (dst.getY() - src.getY()) / (double)d));
        if (style == 9) {
            Polygon poly = new Polygon();
            poly.addPoint((int)dst.getX(), (int)dst.getY());
            poly.addPoint((int)(dst.getX() + (double)(ax / 2) + (double)(ay / 3)), (int)(dst.getY() + (double)(ay / 2) - (double)(ax / 3)));
            Point2D last = (Point2D)dst.clone();
            dst.setLocation(dst.getX() + (double)ax, dst.getY() + (double)ay);
            poly.addPoint((int)dst.getX(), (int)dst.getY());
            poly.addPoint((int)(last.getX() + (double)(ax / 2) - (double)(ay / 3)), (int)(last.getY() + (double)(ay / 2) + (double)(ax / 3)));
            return poly;
        }
        if (style == 2 || style == 1) {
            Polygon poly = new Polygon();
            poly.addPoint((int)dst.getX(), (int)dst.getY());
            poly.addPoint((int)(dst.getX() + (double)ax + (double)(ay / 2)), (int)(dst.getY() + (double)ay - (double)(ax / 2)));
            Point2D last = (Point2D)dst.clone();
            if (style == 1) {
                dst.setLocation((int)(dst.getX() + (double)(ax * 2 / 3)), (int)(dst.getY() + (double)(ay * 2 / 3)));
                poly.addPoint((int)dst.getX(), (int)dst.getY());
            } else if (style == 9) {
                dst.setLocation(dst.getX() + (double)(2 * ax), dst.getY() + (double)(2 * ay));
                poly.addPoint((int)dst.getX(), (int)dst.getY());
            } else {
                dst.setLocation((int)(dst.getX() + (double)ax), (int)(dst.getY() + (double)ay));
            }
            poly.addPoint((int)(last.getX() + (double)ax - (double)(ay / 2)), (int)(last.getY() + (double)ay + (double)(ax / 2)));
            return poly;
        }
        if (style == 4) {
            GeneralPath path = new GeneralPath(1, 4);
            path.moveTo((float)(dst.getX() + (double)ax + (double)(ay / 2)), (float)(dst.getY() + (double)ay - (double)(ax / 2)));
            path.lineTo((float)dst.getX(), (float)dst.getY());
            path.lineTo((float)(dst.getX() + (double)ax - (double)(ay / 2)), (float)(dst.getY() + (double)ay + (double)(ax / 2)));
            return path;
        }
        if (style == 5) {
            Ellipse2D.Float ellipse = new Ellipse2D.Float((float)(dst.getX() + (double)(ax / 2) - (double)(size / 2)), (float)(dst.getY() + (double)(ay / 2) - (double)(size / 2)), size, size);
            dst.setLocation(dst.getX() + (double)ax, dst.getY() + (double)ay);
            return ellipse;
        }
        if (style == 7 || style == 8) {
            GeneralPath path = new GeneralPath(1, 4);
            path.moveTo((float)(dst.getX() + (double)(ax / 2) + (double)(ay / 2)), (float)(dst.getY() + (double)(ay / 2) - (double)(ax / 2)));
            path.lineTo((float)(dst.getX() + (double)(ax / 2) - (double)(ay / 2)), (float)(dst.getY() + (double)(ay / 2) + (double)(ax / 2)));
            if (style == 8) {
                path.moveTo((float)(dst.getX() + (double)(ax / 3) + (double)(ay / 2)), (float)(dst.getY() + (double)(ay / 3) - (double)(ax / 2)));
                path.lineTo((float)(dst.getX() + (double)(ax / 3) - (double)(ay / 2)), (float)(dst.getY() + (double)(ay / 3) + (double)(ax / 2)));
            }
            return path;
        }
        return null;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

