/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jgraph.JGraph;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.PortView;
import org.jgraph.plaf.GraphUI;
import org.jgraph.plaf.basic.BasicGraphUI;

public class EdgeView
extends AbstractCellView {
    public static EdgeRenderer renderer = new EdgeRenderer();
    protected List points;
    protected CellView source;
    protected CellView target;
    protected Point labelPosition;
    public Shape beginShape;
    public Shape endShape;
    public Shape lineShape;
    public transient GeneralPath sharedPath = null;
    protected Rectangle2D cachedLabelBounds = null;
    protected Rectangle2D cachedBounds = null;

    public EdgeView(Object cell, JGraph graph, CellMapper mapper) {
        super(cell, graph, mapper);
    }

    public void refresh(boolean createDependentViews) {
        super.refresh(createDependentViews);
        if (this.points != null) {
            Object modelSource = this.getModel().getSource(this.cell);
            Object modelTarget = this.getModel().getTarget(this.cell);
            this.setSource(this.mapper.getMapping(modelSource, createDependentViews));
            this.setTarget(this.mapper.getMapping(modelTarget, createDependentViews));
            Edge.Routing routing = GraphConstants.getRouting(this.allAttributes);
            if (routing != null) {
                routing.route(this, this.points);
            }
        }
    }

    public void update() {
        super.update();
        this.points = GraphConstants.getPoints(this.allAttributes);
        this.labelPosition = GraphConstants.getLabelPosition(this.allAttributes);
        Edge.Routing routing = GraphConstants.getRouting(this.allAttributes);
        if (routing != null) {
            routing.route(this, this.points);
        }
        if (this.getModel().getSource(this.cell) != null) {
            this.setSource(this.getSource());
        }
        if (this.getModel().getTarget(this.cell) != null) {
            this.setTarget(this.getTarget());
        }
        this.beginShape = null;
        this.endShape = null;
        this.lineShape = null;
        this.sharedPath = null;
        this.cachedBounds = null;
        this.cachedLabelBounds = null;
    }

    void invalidate() {
        this.sharedPath = null;
        this.cachedBounds = null;
        this.cachedLabelBounds = null;
    }

    public Shape getShape() {
        if (this.sharedPath != null) {
            return this.sharedPath;
        }
        this.sharedPath = (GeneralPath)this.getEdgeRenderer().createShape();
        return this.sharedPath;
    }

    public Rectangle2D getLabelBounds() {
        if (this.cachedLabelBounds != null) {
            return this.cachedLabelBounds;
        }
        this.cachedLabelBounds = this.getEdgeRenderer().getLabelBounds(this);
        return this.cachedLabelBounds;
    }

    public boolean intersects(Graphics g, Rectangle2D rect) {
        Rectangle r = new Rectangle((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
        return this.getEdgeRenderer().intersects(g, this, r);
    }

    public Rectangle2D getBounds() {
        if (this.cachedBounds != null) {
            return this.cachedBounds;
        }
        this.cachedBounds = this.getEdgeRenderer().getBounds(this);
        return this.cachedBounds;
    }

    public EdgeRenderer getEdgeRenderer() {
        return (EdgeRenderer)this.getRenderer();
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public CellHandle getHandle(GraphContext context) {
        return new EdgeHandle(this, context);
    }

    public CellView getSource() {
        return this.source;
    }

    public void setSource(CellView sourceView) {
        this.source = sourceView;
        if (this.source != null) {
            this.points.set(0, this.source);
        } else {
            this.points.set(0, this.getPoint(0));
        }
        this.invalidate();
    }

    public CellView getTarget() {
        return this.target;
    }

    public void setTarget(CellView targetView) {
        this.target = targetView;
        int n = this.points.size() - 1;
        if (this.target != null) {
            this.points.set(n, this.target);
        } else {
            this.points.set(n, this.getPoint(n));
        }
        this.invalidate();
    }

    public Point2D getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(Point2D pos) {
        this.labelPosition.setLocation(pos);
        this.invalidate();
    }

    public List getPoints() {
        return this.points;
    }

    public int getPointCount() {
        return this.points.size();
    }

    public Point2D getPoint(int index) {
        Object obj = this.points.get(index);
        if (obj instanceof PortView) {
            return ((PortView)obj).getLocation(this);
        }
        if (obj instanceof CellView) {
            Rectangle2D r = ((CellView)obj).getBounds();
            return this.getAttributes().createPoint(r.getX(), r.getY());
        }
        if (obj instanceof Point2D) {
            return (Point2D)obj;
        }
        return null;
    }

    public void setPoint(int index, Point2D p) {
        this.points.set(index, p);
        this.invalidate();
    }

    public void addPoint(int index, Point2D p) {
        this.points.add(index, p);
        this.invalidate();
    }

    public void removePoint(int index) {
        this.points.remove(index);
        this.invalidate();
    }

    public static double getLength(CellView view) {
        double cost = 1.0;
        if (view instanceof EdgeView) {
            EdgeView edge = (EdgeView)view;
            Point2D last = null;
            Point2D current = null;
            int i = 0;
            while (i < edge.getPointCount()) {
                current = edge.getPoint(i);
                if (last != null) {
                    cost += last.distance(current);
                }
                last = current;
                ++i;
            }
        }
        return cost;
    }

    public static class EdgeHandle
    implements CellHandle,
    Serializable {
        protected JGraph graph;
        protected EdgeView edge;
        protected EdgeView orig;
        protected boolean label = false;
        protected boolean source = false;
        protected boolean target = false;
        protected Point2D currentPoint;
        protected transient Rectangle2D[] r;
        protected transient Rectangle2D loc;
        protected boolean firstOverlayCall = true;
        protected boolean isEdgeConnectable = true;
        protected EdgeView relevantEdge = null;

        public EdgeHandle(EdgeView edge, GraphContext ctx) {
            this.graph = ctx.getGraph();
            this.edge = edge;
            this.loc = new Rectangle();
            this.orig = (EdgeView)this.graph.getGraphLayoutCache().getMapping(edge.getCell(), false);
            this.reloadPoints(this.orig);
            this.isEdgeConnectable = GraphConstants.isConnectable(edge.getAllAttributes());
        }

        protected void reloadPoints(EdgeView edge) {
            this.relevantEdge = edge;
            this.r = new Rectangle[edge.getPointCount()];
            int i = 0;
            while (i < this.r.length) {
                this.r[i] = new Rectangle();
                ++i;
            }
            this.invalidate();
        }

        public void paint(Graphics g) {
            this.invalidate();
            int i = 0;
            while (i < this.r.length) {
                if (this.isEdgeConnectable) {
                    g.setColor(this.graph.getHandleColor());
                } else {
                    g.setColor(this.graph.getLockedHandleColor());
                }
                g.fill3DRect((int)this.r[i].getX(), (int)this.r[i].getY(), (int)this.r[i].getWidth(), (int)this.r[i].getHeight(), true);
                CellView port = null;
                if (i == 0 && this.edge.getSource() != null) {
                    port = this.edge.getSource();
                } else if (i == this.r.length - 1 && this.edge.getTarget() != null) {
                    port = this.edge.getTarget();
                }
                if (port != null) {
                    g.setColor(this.graph.getLockedHandleColor());
                    Point2D tmp = GraphConstants.getOffset(port.getAllAttributes());
                    if (tmp != null) {
                        g.drawLine((int)this.r[i].getX() + 1, (int)this.r[i].getY() + 1, (int)(this.r[i].getX() + this.r[i].getWidth()) - 3, (int)(this.r[i].getY() + this.r[i].getHeight()) - 3);
                        g.drawLine((int)this.r[i].getX() + 1, (int)(this.r[i].getY() + this.r[i].getHeight()) - 3, (int)(this.r[i].getX() + this.r[i].getWidth()) - 3, (int)this.r[i].getY() + 1);
                    } else {
                        g.drawRect((int)this.r[i].getX() + 2, (int)this.r[i].getY() + 2, (int)this.r[i].getWidth() - 5, (int)this.r[i].getHeight() - 5);
                    }
                }
                ++i;
            }
        }

        public void overlay(Graphics g) {
            if (this.edge != null && !this.firstOverlayCall) {
                g.setColor(this.graph.getForeground());
                g.setXORMode(this.graph.getBackground().darker());
                Graphics2D g2 = (Graphics2D)g;
                AffineTransform oldTransform = g2.getTransform();
                g2.scale(this.graph.getScale(), this.graph.getScale());
                this.graph.getUI().paintCell(g, this.edge, this.edge.getBounds(), true);
                g2.setTransform(oldTransform);
                if (this.isSourceEditing() && this.edge.getSource() != null) {
                    this.paintPort(g, this.edge.getSource());
                } else if (this.isTargetEditing() && this.edge.getTarget() != null) {
                    this.paintPort(g, this.edge.getTarget());
                }
            }
            this.firstOverlayCall = false;
        }

        protected void paintPort(Graphics g, CellView p) {
            boolean offset = GraphConstants.getOffset(p.getAllAttributes()) != null;
            Rectangle2D r = offset ? p.getBounds() : p.getParentView().getBounds();
            r = this.graph.toScreen((Rectangle2D)r.clone());
            int s = 3;
            r.setFrame(r.getX() - (double)s, r.getY() - (double)s, r.getWidth() + (double)(2 * s), r.getHeight() + (double)(2 * s));
            this.graph.getUI().paintCell(g, p, r, true);
        }

        protected boolean snap(boolean source, Point2D point) {
            CellView portView;
            boolean connect = this.graph.isConnectable() && this.isEdgeConnectable;
            Object port = this.graph.getPortForLocation(point.getX(), point.getY());
            if (port != null && connect && GraphConstants.isConnectable((portView = this.graph.getGraphLayoutCache().getMapping(port, false)).getParentView().getAllAttributes())) {
                Object cell = this.edge.getCell();
                if (source && this.edge.getSource() != portView && this.edge.getGraph().getModel().acceptsSource(cell, port)) {
                    this.overlay(this.graph.getGraphics());
                    this.edge.setSource(portView);
                    this.edge.update();
                    this.overlay(this.graph.getGraphics());
                } else if (!source && this.edge.getTarget() != portView && this.edge.getGraph().getModel().acceptsTarget(cell, port)) {
                    this.overlay(this.graph.getGraphics());
                    this.edge.setTarget(portView);
                    this.edge.update();
                    this.overlay(this.graph.getGraphics());
                }
                return portView != null;
            }
            return false;
        }

        public boolean isConstrainedMoveEvent(MouseEvent e) {
            GraphUI ui = this.graph.getUI();
            if (ui instanceof BasicGraphUI) {
                return ((BasicGraphUI)ui).isConstrainedMoveEvent(e);
            }
            return false;
        }

        public boolean isAddPointEvent(MouseEvent event) {
            return SwingUtilities.isRightMouseButton(event);
        }

        public boolean isRemovePointEvent(MouseEvent event) {
            return SwingUtilities.isRightMouseButton(event);
        }

        protected boolean isSourceEditing() {
            return this.source;
        }

        protected boolean isTargetEditing() {
            return this.target;
        }

        protected boolean isEditing() {
            return this.source || this.target || this.label || this.currentPoint != null;
        }

        public void mouseMoved(MouseEvent event) {
            int i = 0;
            while (i < this.r.length) {
                if (this.r[i].contains(event.getPoint())) {
                    this.graph.setCursor(new Cursor(1));
                    event.consume();
                    return;
                }
                ++i;
            }
            if (this.loc.contains(event.getPoint()) && this.graph.isMoveable() && GraphConstants.isMoveable(this.edge.getAllAttributes())) {
                this.graph.setCursor(new Cursor(12));
                event.consume();
            }
        }

        public void mousePressed(MouseEvent event) {
            boolean bendable = this.graph.isBendable() && GraphConstants.isBendable(this.edge.getAllAttributes());
            boolean disconnectable = this.graph.isDisconnectable() && GraphConstants.isDisconnectable(this.orig.getAllAttributes());
            int x = event.getX();
            int y = event.getY();
            int index = 0;
            index = 0;
            while (index < this.r.length) {
                if (this.r[index].contains(x, y)) {
                    this.currentPoint = this.edge.getPoint(index);
                    this.source = index == 0 && (this.edge.getSource() == null || disconnectable && GraphConstants.isDisconnectable(this.edge.getSource().getParentView().getAllAttributes()));
                    this.target = index == this.r.length - 1 && (this.edge.getTarget() == null || disconnectable && GraphConstants.isDisconnectable(this.edge.getTarget().getParentView().getAllAttributes()));
                    break;
                }
                ++index;
            }
            if (!this.isEditing() && this.graph.isMoveable() && GraphConstants.isMoveable(this.edge.getAllAttributes()) && this.loc != null && this.loc.contains(x, y) && !this.isAddPointEvent(event) && !this.isRemovePointEvent(event)) {
                if (event.getClickCount() == this.graph.getEditClickCount()) {
                    this.graph.startEditingAtCell(this.edge);
                } else {
                    this.label = true;
                }
            }
            if (this.isRemovePointEvent(event) && this.currentPoint != null && !this.source && !this.target && bendable) {
                this.edge.removePoint(index);
                this.mouseReleased(event);
            } else if (this.isAddPointEvent(event) && !this.isEditing() && bendable) {
                int s = this.graph.getHandleSize();
                Rectangle2D rect = this.graph.fromScreen(new Rectangle(x - s, y - s, 2 * s, 2 * s));
                if (this.edge.intersects(this.graph.getGraphics(), rect)) {
                    Point2D point = this.graph.fromScreen(this.graph.snap(new Point(event.getPoint())));
                    double min = Double.MAX_VALUE;
                    double dist = 0.0;
                    int i = 0;
                    while (i < this.edge.getPointCount() - 1) {
                        Point2D p1;
                        Point2D p = this.edge.getPoint(i);
                        dist = new Line2D.Double(p, p1 = this.edge.getPoint(i + 1)).ptLineDistSq(point);
                        if (dist < min) {
                            min = dist;
                            index = i + 1;
                        }
                        ++i;
                    }
                    this.edge.addPoint(index, point);
                    this.currentPoint = point;
                    this.reloadPoints(this.edge);
                    this.paint(this.graph.getGraphics());
                }
            }
            if (this.isEditing()) {
                event.consume();
            }
        }

        public void mouseDragged(MouseEvent event) {
            Point2D p = this.graph.fromScreen(new Point(event.getPoint()));
            if (this.label) {
                Rectangle2D r = this.edge.getBounds();
                if (r != null) {
                    Point2D p0 = this.edge.getPoint(0);
                    Point2D pe = this.edge.getPoint(this.edge.getPointCount() - 1);
                    double vx = p.getX() - r.getX();
                    if (p0.getX() > pe.getX()) {
                        vx = r.getX() + r.getWidth() - p.getX();
                    }
                    double vy = p.getY() - r.getY();
                    if (p0.getY() > pe.getY()) {
                        vy = r.getY() + r.getHeight() - p.getY();
                    }
                    double xunit = 1.0;
                    if (r.getWidth() != 0.0) {
                        xunit = 1000.0 / r.getWidth();
                    }
                    double yunit = 1.0;
                    if (r.getHeight() != 0.0) {
                        yunit = 1000.0 / r.getHeight();
                    }
                    p = this.edge.getAttributes().createPoint(vx * xunit, vy * yunit);
                    this.overlay(this.graph.getGraphics());
                    this.edge.setLabelPosition(p);
                    this.edge.update();
                    this.overlay(this.graph.getGraphics());
                }
            } else if (!(!this.isEditing() || this.source && this.snap(true, p) || this.target && this.snap(false, p) || !(this.source && this.edge.getGraph().getModel().acceptsSource(this.edge.getCell(), null) || this.target && this.edge.getGraph().getModel().acceptsTarget(this.edge.getCell(), null)) && (this.source || this.target))) {
                this.overlay(this.graph.getGraphics());
                p = this.graph.fromScreen(this.graph.snap(new Point(event.getPoint())));
                if (this.isConstrainedMoveEvent(event)) {
                    EdgeView orig = (EdgeView)this.graph.getGraphLayoutCache().getMapping(this.edge.getCell(), false);
                    int index = 0;
                    if (this.target) {
                        index = orig.getPointCount() - 1;
                    }
                    Point2D origPoint = orig.getPoint(index);
                    double totDx = p.getX() - origPoint.getX();
                    double totDy = p.getY() - origPoint.getY();
                    if (Math.abs(totDx) < Math.abs(totDy)) {
                        p.setLocation(origPoint.getX(), p.getY());
                    } else {
                        p.setLocation(p.getX(), origPoint.getY());
                    }
                }
                p.setLocation(Math.max(0.0, p.getX()), Math.max(0.0, p.getY()));
                this.currentPoint.setLocation(p);
                if (this.source) {
                    this.edge.setPoint(0, p);
                    this.edge.setSource(null);
                } else if (this.target) {
                    this.edge.setPoint(this.edge.getPointCount() - 1, p);
                    this.edge.setTarget(null);
                }
                this.edge.update();
                this.overlay(this.graph.getGraphics());
            }
        }

        public void mouseReleased(MouseEvent e) {
            boolean clone = e.isControlDown() && this.graph.isCloneable();
            ConnectionSet cs = this.createConnectionSet(this.edge, this.edge.getCell(), clone);
            Map nested = GraphConstants.createAttributes(new CellView[]{this.edge}, null);
            if (clone) {
                Map cellMap = this.graph.cloneCells(new Object[]{this.edge.getCell()});
                nested = GraphConstants.replaceKeys(cellMap, nested);
                cs = cs.clone(cellMap);
                this.graph.getGraphLayoutCache().insert(cellMap.values().toArray(), nested, cs, null, null);
            } else {
                this.graph.getGraphLayoutCache().edit(nested, cs, null, null);
            }
            e.consume();
        }

        protected ConnectionSet createConnectionSet(EdgeView view, Object edge, boolean verbose) {
            ConnectionSet cs = new ConnectionSet();
            Object sourcePort = null;
            Object targetPort = null;
            if (view.getSource() != null) {
                sourcePort = view.getSource().getCell();
            }
            if (view.getTarget() != null) {
                targetPort = view.getTarget().getCell();
            }
            if (verbose || sourcePort != view.getGraph().getModel().getSource(edge)) {
                cs.connect(edge, sourcePort, true);
            }
            if (verbose || targetPort != view.getGraph().getModel().getTarget(edge)) {
                cs.connect(edge, targetPort, false);
            }
            return cs;
        }

        protected void invalidate() {
            EdgeView e = this.relevantEdge;
            int handlesize = this.graph.getHandleSize();
            EdgeRenderer er = (EdgeRenderer)this.edge.getRenderer();
            int i = 0;
            while (i < this.r.length) {
                Point2D p = this.graph.toScreen(this.edge.getAttributes().createPoint(e.getPoint(i)));
                this.r[i].setFrame(p.getX() - (double)handlesize, p.getY() - (double)handlesize, 2 * handlesize, 2 * handlesize);
                p = this.graph.toScreen(er.getLabelPosition(e));
                Dimension d = er.getLabelSize(e);
                if (p != null && d != null) {
                    Point2D s = this.graph.toScreen(this.edge.getAttributes().createPoint(d.width, d.height));
                    this.loc.setFrame(p.getX() - s.getX() / 2.0, p.getY() - s.getY() / 2.0, s.getX(), s.getY());
                }
                ++i;
            }
        }
    }
}

