/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.PortView;

public class GraphContext
implements CellMapper {
    protected JGraph graph;
    protected transient GraphLayoutCache graphLayoutCache;
    protected Object[] cells;
    protected Set cellSet;
    protected int cellCount;
    protected Map views = new Hashtable();

    public GraphContext(JGraph graph, Object[] cells) {
        GraphModel model = graph.getModel();
        this.cellSet = DefaultGraphModel.getDescendants(model, cells);
        this.graphLayoutCache = graph.getGraphLayoutCache();
        this.graph = graph;
        this.cells = cells;
        Iterator it = this.cellSet.iterator();
        while (it.hasNext()) {
            if (model.isPort(it.next())) continue;
            ++this.cellCount;
        }
    }

    public boolean isEmpty() {
        return this.cells == null || this.cells.length == 0;
    }

    public int getDescendantCount() {
        return this.cellCount;
    }

    public JGraph getGraph() {
        return this.graph;
    }

    public Object[] getCells() {
        return this.cells;
    }

    public boolean contains(Object node) {
        return this.cellSet.contains(node);
    }

    public CellView[] createTemporaryCellViews() {
        CellView[] cellViews = new CellView[this.cells.length];
        int i = 0;
        while (i < this.cells.length) {
            cellViews[i] = this.getMapping(this.cells[i], true);
            ++i;
        }
        return cellViews;
    }

    public CellView[] createTemporaryPortViews() {
        GraphModel model = this.graph.getModel();
        ArrayList<CellView> result = new ArrayList<CellView>();
        Iterator it = this.cellSet.iterator();
        while (it.hasNext()) {
            Object cand = it.next();
            if (!model.isPort(cand) || !this.graph.getGraphLayoutCache().isVisible(cand)) continue;
            result.add(this.getMapping(cand, true));
        }
        CellView[] array = new PortView[result.size()];
        result.toArray(array);
        return array;
    }

    public CellView[] createTemporaryContextViews() {
        return this.createTemporaryContextViews(this.cellSet);
    }

    public CellView[] createTemporaryContextViews(Set cellSet) {
        Object[] cells = cellSet.toArray();
        Set set = DefaultGraphModel.getEdges(this.graph.getModel(), cells);
        ArrayList<CellView> result = new ArrayList<CellView>();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (cellSet.contains(obj) || !this.graphLayoutCache.isVisible(obj) || this.graphLayoutCache.getMapping(obj, false) == null) continue;
            result.add(this.createMapping(obj));
        }
        CellView[] array = new CellView[result.size()];
        result.toArray(array);
        return array;
    }

    public CellView getMapping(Object cell, boolean create) {
        if (cell != null) {
            CellView view = (CellView)this.views.get(cell);
            if (view != null) {
                return view;
            }
            if (this.contains(cell)) {
                return this.createMapping(cell);
            }
            return this.graphLayoutCache.getMapping(cell, false);
        }
        return null;
    }

    public CellView createMapping(Object cell) {
        CellView src = this.graphLayoutCache.getMapping(cell, false);
        CellView view = this.graphLayoutCache.getFactory().createView(this.getGraph(), this, cell);
        if (src != null) {
            view.setAttributes((AttributeMap)src.getAllAttributes().clone());
            view.refresh(false);
        }
        return view;
    }

    public ConnectionSet disconnect(CellView[] cells) {
        ConnectionSet cs = new ConnectionSet();
        int i = 0;
        while (i < cells.length) {
            if (cells[i] instanceof EdgeView) {
                EdgeView view = (EdgeView)cells[i];
                CellView port = view.getSource();
                if (GraphConstants.isDisconnectable(view.getAllAttributes())) {
                    if (port != null && GraphConstants.isDisconnectable(port.getParentView().getAllAttributes()) && !this.contains(port.getCell())) {
                        view.setSource(null);
                        cs.disconnect(view.getCell(), true);
                    }
                    if ((port = view.getTarget()) != null && GraphConstants.isDisconnectable(port.getParentView().getAllAttributes()) && !this.contains(port.getCell())) {
                        view.setTarget(null);
                        cs.disconnect(view.getCell(), false);
                    }
                }
            }
            ++i;
        }
        return cs;
    }

    public void putMapping(Object cell, CellView view) {
        this.views.put(cell, view);
    }
}

