/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.Stack;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.ParentMap;
import org.jgraph.graph.PortView;

public class GraphLayoutCache
extends Observable
implements CellMapper,
Serializable {
    public boolean showAllEdgesForVisibleVertices = true;
    public boolean showEdgesOnShow = true;
    public boolean hideEdgesOnHide = true;
    public boolean hideEdgesOnBecomeInvisible = true;
    public boolean rememberCellViews = true;
    protected GraphModel graphModel;
    protected Map mapping = new Hashtable();
    protected CellMapper mapper;
    protected CellViewFactory factory = null;
    protected JGraph graph = null;
    protected Set visibleSet = new HashSet();
    protected List roots = new ArrayList();
    protected PortView[] ports;
    protected transient Map hiddenSet = new Hashtable();
    protected boolean ordered = false;
    protected boolean partial = false;
    protected boolean askLocalAttribute = true;
    protected Set localAttributes = new HashSet();

    public GraphLayoutCache(JGraph graph) {
        this(graph, graph.getModel(), graph, false, false);
    }

    public GraphLayoutCache(JGraph graph, Set localAttributes) {
        this(graph, graph.getModel(), graph, false, false);
        this.setLocalAttributes(localAttributes);
    }

    public GraphLayoutCache(JGraph graph, GraphModel model, CellViewFactory factory, boolean ordered, boolean partial) {
        this(graph, model, factory, ordered, partial, true, true, true, true, true);
    }

    public GraphLayoutCache(JGraph graph, GraphModel model, CellViewFactory factory, boolean ordered, boolean partial, boolean rememberCellViews, boolean showAllEdgesForVisibleVertices, boolean showEdgesOnShow, boolean hideEdgesOnHide, boolean hideEdgesOnBecomeInvisible) {
        this.graph = graph;
        this.factory = factory;
        this.ordered = ordered;
        this.partial = partial;
        this.rememberCellViews = rememberCellViews;
        this.showAllEdgesForVisibleVertices = showAllEdgesForVisibleVertices;
        this.showEdgesOnShow = showEdgesOnShow;
        this.hideEdgesOnHide = hideEdgesOnHide;
        this.hideEdgesOnBecomeInvisible = hideEdgesOnBecomeInvisible;
        this.setModel(model);
    }

    public JGraph getGraph() {
        return this.graph;
    }

    public void setFactory(CellViewFactory factory) {
        this.factory = factory;
    }

    public CellViewFactory getFactory() {
        return this.factory;
    }

    public void setModel(GraphModel model) {
        this.roots.clear();
        this.mapping.clear();
        this.hiddenSet.clear();
        this.visibleSet.clear();
        this.graphModel = model;
        Object[] cells = DefaultGraphModel.getRoots(model);
        if (!this.isPartial()) {
            this.insertRoots(this.getMapping(cells, true));
        }
        if (cells != null) {
            int i = 0;
            while (i < cells.length) {
                this.factory.updateAutoSize(this.getGraph(), this.getMapping(cells[i], false));
                ++i;
            }
        }
        this.updatePorts();
    }

    public synchronized void reload() {
        ArrayList<CellView> newRoots = new ArrayList<CellView>();
        Hashtable oldMapping = new Hashtable(this.mapping);
        this.mapping.clear();
        Iterator it = oldMapping.keySet().iterator();
        while (it.hasNext()) {
            Object cell = it.next();
            CellView oldView = (CellView)oldMapping.get(cell);
            CellView newView = this.getMapping(cell, true);
            newView.setAttributes(oldView.getAttributes());
            if (!this.roots.contains(oldView)) continue;
            newRoots.add(newView);
        }
        this.hiddenSet.clear();
        this.roots = newRoots;
    }

    public GraphModel getModel() {
        return this.graphModel;
    }

    public CellView[] getRoots() {
        CellView[] views = new CellView[this.roots.size()];
        this.roots.toArray(views);
        return views;
    }

    public CellView[] getRoots(Rectangle2D clip) {
        ArrayList<CellView> result = new ArrayList<CellView>();
        CellView[] views = this.getRoots();
        int i = 0;
        while (i < views.length) {
            if (views[i].getBounds().intersects(clip)) {
                result.add(views[i]);
            }
            ++i;
        }
        views = new CellView[result.size()];
        result.toArray(views);
        return views;
    }

    public PortView[] getPorts() {
        return this.ports;
    }

    protected void updatePorts() {
        Object[] roots = DefaultGraphModel.getRoots(this.graphModel);
        Set set = DefaultGraphModel.getDescendants(this.graphModel, roots);
        if (set != null) {
            Object[] all = set.toArray();
            ArrayList<CellView> result = new ArrayList<CellView>();
            int i = 0;
            while (i < all.length) {
                CellView portView;
                if (this.graphModel.isPort(all[i]) && (portView = this.getMapping(all[i], false)) != null) {
                    result.add(portView);
                    portView.refresh(false);
                }
                ++i;
            }
            this.ports = new PortView[result.size()];
            result.toArray(this.ports);
        }
    }

    public void refresh(CellView[] views, boolean create) {
        if (views != null) {
            int i = 0;
            while (i < views.length) {
                this.refresh(views[i], create);
                ++i;
            }
        }
    }

    public void refresh(CellView view, boolean create) {
        if (view != null) {
            view.refresh(create);
            CellView[] children = view.getChildViews();
            int i = 0;
            while (i < children.length) {
                this.refresh(children[i], create);
                ++i;
            }
        }
    }

    public void update(CellView[] views) {
        if (views != null) {
            int i = 0;
            while (i < views.length) {
                this.update(views[i]);
                ++i;
            }
        }
    }

    public void update(CellView view) {
        if (view != null) {
            view.update();
            CellView[] children = view.getChildViews();
            int i = 0;
            while (i < children.length) {
                this.update(children[i]);
                ++i;
            }
        }
    }

    public void graphChanged(GraphModelEvent.GraphModelChange change) {
        Object[] inserted;
        CellView[] views = change.getViews(this);
        if (views != null) {
            int i = 0;
            while (i < views.length) {
                if (views[i] != null) {
                    this.mapping.put(views[i].getCell(), views[i]);
                }
                ++i;
            }
            this.setVisibleImpl(this.getCells(views), true);
        }
        Object[] changed = this.order(change.getChanged());
        CellView[] insertViews = this.getMapping(change.getInserted(), true);
        views = this.removeRoots(change.getRemoved());
        change.putViews(this, views);
        this.insertRoots(insertViews);
        if (this.isPartial()) {
            this.showCellsForChange(change);
            this.hideCellsForChange(change);
        }
        if (changed != null && changed.length > 0) {
            if (!this.isOrdered()) {
                this.roots.clear();
                Object[] rootCells = DefaultGraphModel.getRoots(this.graphModel);
                CellView[] rootViews = this.getMapping(rootCells, false);
                int i = 0;
                while (i < rootViews.length) {
                    if (rootViews[i] != null) {
                        this.roots.add(rootViews[i]);
                        rootViews[i].refresh(true);
                        this.factory.updateAutoSize(this.getGraph(), rootViews[i]);
                    }
                    ++i;
                }
            }
            int i = 0;
            while (i < changed.length) {
                CellView view = this.getMapping(changed[i], false);
                if (view != null) {
                    view.refresh(true);
                    this.update(view);
                    this.factory.updateAutoSize(this.getGraph(), view);
                    if (this.isOrdered()) {
                        CellView parentView = view.getParentView();
                        Object par = parentView != null ? parentView.getCell() : null;
                        boolean isRoot = this.roots.contains(view);
                        if (par == null && !isRoot) {
                            this.roots.add(view);
                        } else if (par != null && isRoot) {
                            this.roots.remove(view);
                        }
                    }
                }
                ++i;
            }
        }
        if ((inserted = change.getInserted()) != null && inserted.length > 0) {
            int i = 0;
            while (i < inserted.length) {
                this.factory.updateAutoSize(this.getGraph(), this.getMapping(inserted[i], false));
                ++i;
            }
        }
        this.refresh(this.getMapping(change.getContext(), false), false);
        Object[] removed = change.getRemoved();
        if (removed != null && removed.length > 0 || inserted != null && inserted.length > 0 || !this.isOrdered()) {
            this.updatePorts();
        }
    }

    protected void hideCellsForChange(GraphModelEvent.GraphModelChange change) {
        Object[] tmp = change.getRemoved();
        HashSet<Object> removed = new HashSet<Object>();
        if (tmp != null) {
            int i = 0;
            while (i < tmp.length) {
                removed.add(tmp[i]);
                ++i;
            }
        }
        if (this.hideEdgesOnBecomeInvisible) {
            Object[] changed = change.getChanged();
            int i = 0;
            while (i < changed.length) {
                CellView view = this.getMapping(changed[i], false);
                if (view instanceof EdgeView) {
                    EdgeView edge = (EdgeView)view;
                    Object oldSource = edge.getSource() == null ? null : edge.getSource().getCell();
                    Object oldTarget = edge.getTarget() == null ? null : edge.getTarget().getCell();
                    Object newSource = this.graphModel.getSource(changed[i]);
                    Object newTarget = this.graphModel.getTarget(changed[i]);
                    if (removed.contains(oldSource) || removed.contains(oldTarget) || newSource != null && !this.isVisible(newSource) || newTarget != null && !this.isVisible(newTarget)) {
                        this.setVisibleImpl(new Object[]{changed[i]}, false);
                    }
                }
                ++i;
            }
        }
    }

    protected void showCellsForChange(GraphModelEvent.GraphModelChange change) {
        if (this.showAllEdgesForVisibleVertices) {
            Object[] changed;
            Object[] inserted = change.getInserted();
            if (inserted != null) {
                int i = 0;
                while (i < inserted.length) {
                    if (!this.isVisible(inserted[i]) && this.showAllEdgesForVisibleVertices) {
                        Object source = this.graphModel.getSource(inserted[i]);
                        Object target = this.graphModel.getTarget(inserted[i]);
                        if ((source != null || target != null) && this.isVisible(source) && this.isVisible(target)) {
                            this.setVisible(inserted[i], true);
                        }
                    }
                    ++i;
                }
            }
            if ((changed = change.getChanged()) != null) {
                int i = 0;
                while (i < changed.length) {
                    if (!this.isVisible(changed[i])) {
                        Object source = this.graphModel.getSource(changed[i]);
                        Object target = this.graphModel.getTarget(changed[i]);
                        if ((source != null || target != null) && this.isVisible(source) && this.isVisible(target)) {
                            this.setVisible(changed[i], true);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public void insertRoots(CellView[] views) {
        if (views != null) {
            this.refresh(views, true);
            int i = 0;
            while (i < views.length) {
                if (views[i] != null && this.getMapping(views[i].getCell(), false) != null) {
                    Object parent;
                    CellView parentView = views[i].getParentView();
                    Object object = parent = parentView != null ? parentView.getCell() : null;
                    if (!(views[i] instanceof PortView) && !this.roots.contains(views[i]) && parent == null) {
                        this.roots.add(views[i]);
                    }
                }
                ++i;
            }
        }
    }

    public CellView[] removeRoots(Object[] cells) {
        if (cells != null) {
            CellView[] views = new CellView[cells.length];
            int i = 0;
            while (i < cells.length) {
                views[i] = this.removeMapping(cells[i]);
                if (views[i] != null) {
                    views[i].removeFromParent();
                    this.roots.remove(views[i]);
                }
                ++i;
            }
            this.setVisibleImpl(cells, false);
            return views;
        }
        return null;
    }

    public Object[] getCells(CellView[] views) {
        if (views != null) {
            Object[] cells = new Object[views.length];
            int i = 0;
            while (i < views.length) {
                if (views[i] != null) {
                    cells[i] = views[i].getCell();
                }
                ++i;
            }
            return cells;
        }
        return null;
    }

    public CellView getMapping(Object cell, boolean create) {
        if (cell == null) {
            return null;
        }
        CellView view = (CellView)this.mapping.get(cell);
        if (view == null && create) {
            view = (CellView)this.hiddenSet.get(cell);
            if (view != null && this.isVisible(cell)) {
                this.putMapping(cell, view);
                this.hiddenSet.remove(cell);
            } else {
                view = this.factory.createView(this.getGraph(), this, cell);
            }
        }
        return view;
    }

    public CellView[] getMapping(Object[] cells) {
        return this.getMapping(cells, false);
    }

    public CellView[] getMapping(Object[] cells, boolean create) {
        if (cells != null) {
            CellView[] result = new CellView[cells.length];
            int i = 0;
            while (i < cells.length) {
                result[i] = this.getMapping(cells[i], create);
                ++i;
            }
            return result;
        }
        return null;
    }

    public void putMapping(Object cell, CellView view) {
        if (cell != null && view != null && this.isVisible(cell)) {
            this.mapping.put(cell, view);
        }
    }

    public CellView removeMapping(Object cell) {
        if (cell != null) {
            CellView view = (CellView)this.mapping.remove(cell);
            return view;
        }
        return null;
    }

    public boolean isVisible(Object cell) {
        return !this.isPartial() || this.visibleSet.contains(cell) || cell == null;
    }

    public Set getVisibleSet() {
        return new HashSet(this.visibleSet);
    }

    public void setVisibleSet(Set visible) {
        this.visibleSet = visible;
    }

    public void setVisible(Object cell, boolean visible) {
        this.setVisible(new Object[]{cell}, visible);
    }

    public void setVisible(Object[] cells, boolean visible) {
        if (visible) {
            this.setVisible(cells, null);
        } else {
            this.setVisible(null, cells);
        }
    }

    public void setVisible(Object[] visible, Object[] invisible) {
        visible = this.addVisibleDependencies(visible, true);
        invisible = this.addVisibleDependencies(invisible, false);
        GraphViewEdit edit = new GraphViewEdit(null, visible, invisible);
        edit.end();
        this.graphModel.edit(null, null, null, new UndoableEdit[]{edit});
    }

    public Object[] addVisibleDependencies(Object[] cells, boolean visible) {
        if (cells != null) {
            if (visible) {
                HashSet<Object> all = new HashSet<Object>();
                int i = 0;
                while (i < cells.length) {
                    all.add(cells[i]);
                    all.addAll(this.getPorts(cells[i]));
                    all.addAll(this.getParentPorts(this.graphModel.getSource(cells[i])));
                    all.addAll(this.getParentPorts(this.graphModel.getTarget(cells[i])));
                    ++i;
                }
                if (this.showEdgesOnShow) {
                    Set tmp = DefaultGraphModel.getEdges(this.getModel(), cells);
                    Iterator it = tmp.iterator();
                    while (it.hasNext()) {
                        Object obj = it.next();
                        Object source = this.graphModel.getSource(obj);
                        Object target = this.graphModel.getTarget(obj);
                        if (!this.isVisible(source) && !all.contains(source) || !this.isVisible(target) && !all.contains(target)) continue;
                        all.add(obj);
                    }
                }
                all.removeAll(this.visibleSet);
                return all.toArray();
            }
            if (this.hideEdgesOnHide) {
                HashSet<Object> all = new HashSet<Object>();
                int i = 0;
                while (i < cells.length) {
                    all.addAll(this.getPorts(cells[i]));
                    all.add(cells[i]);
                    ++i;
                }
                all.addAll(DefaultGraphModel.getEdges(this.graphModel, cells));
                all.retainAll(this.visibleSet);
                return all.toArray();
            }
        }
        return null;
    }

    public boolean setVisibleImpl(Object[] cells, boolean visible) {
        if (cells != null && this.isPartial()) {
            boolean updatePorts = false;
            int i = 0;
            while (i < cells.length) {
                if (cells[i] != null) {
                    if (visible) {
                        this.visibleSet.add(cells[i]);
                    } else {
                        this.visibleSet.remove(cells[i]);
                    }
                }
                ++i;
            }
            i = 0;
            while (i < cells.length) {
                if (cells[i] != null) {
                    CellView view;
                    if (!visible) {
                        view = this.getMapping(cells[i], false);
                        if (view != null) {
                            view.removeFromParent();
                            view.refresh(false);
                            this.removeMapping(cells[i]);
                            this.roots.remove(view);
                            if (this.graphModel.contains(cells[i]) && this.rememberCellViews) {
                                this.hiddenSet.put(view.getCell(), view);
                            }
                            updatePorts = true;
                        }
                    } else {
                        view = this.getMapping(cells[i], true);
                        CellView[] children = AbstractCellView.getDescendantViews(new CellView[]{view});
                        int j = 0;
                        while (j < children.length) {
                            this.roots.remove(children[j]);
                            ++j;
                        }
                        view.refresh(false);
                        this.factory.updateAutoSize(this.getGraph(), view);
                        CellView parentView = view.getParentView();
                        if (parentView != null) {
                            parentView.refresh(true);
                        } else {
                            this.insertRoots(new CellView[]{view});
                        }
                        updatePorts = true;
                    }
                }
                ++i;
            }
            return updatePorts;
        }
        return false;
    }

    protected Collection getParentPorts(Object cell) {
        Object parent = this.graphModel.getParent(cell);
        Collection collection = this.getPorts(parent);
        collection.add(parent);
        return collection;
    }

    protected Collection getPorts(Object cell) {
        LinkedList<Object> list = new LinkedList<Object>();
        int i = 0;
        while (i < this.graphModel.getChildCount(cell)) {
            Object child = this.graphModel.getChild(cell, i);
            if (this.graphModel.isPort(child)) {
                list.add(child);
            }
            ++i;
        }
        return list;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public void valueForCellChanged(Object cell, Object newValue) {
        Map nested = GraphConstants.createAttributes(cell, (Object)"value", newValue);
        this.edit(nested, null, null, null);
    }

    public void insert(Object[] roots, Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] e) {
        Object[] visible = null;
        if (this.isPartial()) {
            HashSet tmp = new HashSet(DefaultGraphModel.getDescendants(this.graphModel, roots));
            tmp.removeAll(this.visibleSet);
            if (!tmp.isEmpty()) {
                visible = tmp.toArray();
            }
        }
        GraphViewEdit edit = this.createLocalEdit(attributes, visible, null);
        this.setVisibleImpl(visible, true);
        if (edit != null) {
            e = this.augment(e, edit);
        }
        this.graphModel.insert(roots, attributes, cs, pm, e);
    }

    public void remove(Object[] roots) {
        this.graphModel.remove(roots);
    }

    public void edit(Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] e) {
        GraphViewEdit edit;
        Object[] visible = null;
        if (this.isPartial()) {
            HashSet tmp = new HashSet(attributes.keySet());
            tmp.removeAll(this.visibleSet);
            if (!tmp.isEmpty()) {
                visible = tmp.toArray();
            }
        }
        if ((edit = this.createLocalEdit(attributes, visible, null)) != null) {
            e = this.augment(e, edit);
        }
        this.graphModel.edit(attributes, cs, pm, e);
    }

    protected UndoableEdit[] augment(UndoableEdit[] e, UndoableEdit edit) {
        if (edit != null) {
            int size = e != null ? e.length + 1 : 1;
            UndoableEdit[] result = new UndoableEdit[size];
            if (e != null) {
                System.arraycopy(e, 0, result, 0, size - 2);
            }
            result[size - 1] = edit;
            return result;
        }
        return e;
    }

    public void toBack(Object[] cells) {
        if (cells != null && cells.length > 0) {
            if (this.isOrdered()) {
                Object[] views = this.getMapping(cells, false);
                GraphViewLayerEdit edit = new GraphViewLayerEdit(this, views, -2);
                this.graphModel.edit(null, null, null, new UndoableEdit[]{edit});
            } else {
                this.graphModel.toBack(cells);
            }
        }
    }

    public void toFront(Object[] cells) {
        if (cells != null && cells.length > 0) {
            if (this.isOrdered()) {
                Object[] views = this.getMapping(cells, false);
                GraphViewLayerEdit edit = new GraphViewLayerEdit(this, views, -1);
                this.graphModel.edit(null, null, null, new UndoableEdit[]{edit});
            } else {
                this.graphModel.toFront(cells);
            }
        }
    }

    protected GraphViewEdit createLocalEdit(Map nested, Object[] visible, Object[] invisible) {
        if (nested != null && !nested.isEmpty() && this.isAskLocalAttribute()) {
            Hashtable globalMap = new Hashtable();
            Hashtable localMap = new Hashtable();
            Iterator it = nested.entrySet().iterator();
            while (it.hasNext()) {
                AttributeMap localAttr = this.graphModel.createAttributes();
                Map.Entry entry = it.next();
                Object cell = entry.getKey();
                AttributeMap attr = (AttributeMap)entry.getValue();
                CellView tmpView = this.getMapping(cell, false);
                if (tmpView != null) {
                    attr = tmpView.getAllAttributes().diff(attr);
                }
                Iterator it2 = attr.entrySet().iterator();
                while (it2.hasNext()) {
                    Map.Entry entry2 = it2.next();
                    Object key = entry2.getKey();
                    Object value = entry2.getValue();
                    boolean isControlAttribute = this.isControlAttribute(cell, key, value);
                    if (!this.isLocalAttribute(cell, key, value) && !isControlAttribute) continue;
                    localAttr.put(key, value);
                    if (isControlAttribute) continue;
                    it2.remove();
                }
                if (!localAttr.isEmpty()) {
                    localMap.put(cell, localAttr);
                }
                if (attr.isEmpty()) continue;
                globalMap.put(cell, attr);
            }
            nested.clear();
            nested.putAll(globalMap);
            GraphViewEdit edit = new GraphViewEdit(new Hashtable(localMap), visible, invisible);
            edit.end();
            return edit;
        }
        if (visible != null || invisible != null) {
            GraphViewEdit edit = new GraphViewEdit(null, visible, invisible);
            edit.end();
            return edit;
        }
        return null;
    }

    protected boolean isLocalAttribute(Object cell, Object key, Object value) {
        return this.localAttributes.contains(key);
    }

    protected boolean isControlAttribute(Object cell, Object key, Object value) {
        return "removeAll".equals(key) || "removeAttributes".equals(key);
    }

    public Object[] order(Object[] cells) {
        if (cells != null) {
            if (this.graphModel != null && this.isOrdered()) {
                HashSet<Object> cellSet = new HashSet<Object>();
                int i = 0;
                while (i < cells.length) {
                    cellSet.add(cells[i]);
                    ++i;
                }
                CellView[] views = this.getRoots();
                Stack<CellView> s = new Stack<CellView>();
                int i2 = 0;
                while (i2 < views.length) {
                    s.add(views[i2]);
                    ++i2;
                }
                ArrayList<Object> result = new ArrayList<Object>();
                while (!s.isEmpty()) {
                    CellView cell = (CellView)s.pop();
                    if (cellSet.contains(cell.getCell())) {
                        result.add(cell.getCell());
                    }
                    CellView[] children = cell.getChildViews();
                    int i3 = 0;
                    while (i3 < children.length) {
                        s.add(children[i3]);
                        ++i3;
                    }
                    i3 = this.graphModel.getChildCount(cell.getCell()) - 1;
                    while (i3 >= 0) {
                        CellView portView;
                        Object port = this.graphModel.getChild(cell.getCell(), i3);
                        if (this.graphModel.isPort(port) && (portView = this.getMapping(port, false)) != null) {
                            s.add(portView);
                        }
                        --i3;
                    }
                }
                int i4 = result.size();
                Object[] tmp = new Object[i4];
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    tmp[--i4] = it.next();
                }
                return tmp;
            }
            Object[] tmp = new Object[cells.length];
            int i = 0;
            while (i < cells.length) {
                tmp[cells.length - i - 1] = cells[i];
                ++i;
            }
            return tmp;
        }
        return cells;
    }

    protected Map handleAttributes(Map attributes) {
        Hashtable<Object, AttributeMap> undo = new Hashtable<Object, AttributeMap>();
        CellView[] views = new CellView[attributes.size()];
        Iterator it = attributes.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            CellView cv;
            Map.Entry entry = it.next();
            views[i] = cv = this.getMapping(entry.getKey(), false);
            ++i;
            if (cv == null) continue;
            AttributeMap deltaNew = (AttributeMap)entry.getValue();
            AttributeMap deltaOld = cv.setAttributes(deltaNew);
            cv.refresh(false);
            undo.put(cv.getCell(), deltaOld);
            this.factory.updateAutoSize(this.getGraph(), cv);
        }
        this.update(views);
        return undo;
    }

    public static void translateViews(CellView[] views, double dx, double dy) {
        views = AbstractCellView.getDescendantViews(views);
        int i = 0;
        while (i < views.length) {
            if (views[i].isLeaf()) {
                views[i].getAllAttributes().translate(dx, dy);
            }
            ++i;
        }
    }

    public CellView[] getAllDescendants(CellView[] views) {
        Stack<CellView> stack = new Stack<CellView>();
        int i = 0;
        while (i < views.length) {
            if (views[i] != null) {
                stack.add(views[i]);
            }
            ++i;
        }
        ArrayList<CellView> result = new ArrayList<CellView>();
        while (!stack.isEmpty()) {
            CellView tmp = (CellView)stack.pop();
            CellView[] children = tmp.getChildViews();
            int i2 = 0;
            while (i2 < children.length) {
                stack.add(children[i2]);
                ++i2;
            }
            result.add(tmp);
            i2 = 0;
            while (i2 < this.graphModel.getChildCount(tmp.getCell())) {
                CellView view;
                Object child = this.graphModel.getChild(tmp.getCell(), i2);
                if (this.graphModel.isPort(child) && (view = this.getMapping(child, false)) != null) {
                    stack.add(view);
                }
                ++i2;
            }
        }
        CellView[] ret = new CellView[result.size()];
        result.toArray(ret);
        return ret;
    }

    public Map getHiddenSet() {
        return this.hiddenSet;
    }

    public boolean isHideEdgesOnBecomeInvisible() {
        return this.hideEdgesOnBecomeInvisible;
    }

    public boolean isHideEdgesOnHide() {
        return this.hideEdgesOnHide;
    }

    public boolean isRememberCellViews() {
        return this.rememberCellViews;
    }

    public boolean isShowAllEdgesForVisibleVertices() {
        return this.showAllEdgesForVisibleVertices;
    }

    public boolean isShowEdgesOnShow() {
        return this.showEdgesOnShow;
    }

    public void setHiddenSet(Map hiddenSet) {
        this.hiddenSet = hiddenSet;
    }

    public void setHideEdgesOnBecomeInvisible(boolean hideEdgesOnBecomeInvisible) {
        this.hideEdgesOnBecomeInvisible = hideEdgesOnBecomeInvisible;
    }

    public void setHideEdgesOnHide(boolean hideEdgesOnHide) {
        this.hideEdgesOnHide = hideEdgesOnHide;
    }

    public void setRememberCellViews(boolean rememberCellViews) {
        this.rememberCellViews = rememberCellViews;
    }

    public void setShowAllEdgesForVisibleVertices(boolean showAllEdgesForVisibleVertices) {
        this.showAllEdgesForVisibleVertices = showAllEdgesForVisibleVertices;
    }

    public void setShowEdgesOnShow(boolean showEdgesOnShow) {
        this.showEdgesOnShow = showEdgesOnShow;
    }

    public Set getLocalAttributes() {
        return this.localAttributes;
    }

    public void setLocalAttributes(Set localAttributes) {
        this.localAttributes = localAttributes;
    }

    public boolean isAskLocalAttribute() {
        return this.askLocalAttribute;
    }

    public void setAskLocalAttribute(boolean askLocalAttribute) {
        this.askLocalAttribute = askLocalAttribute;
    }

    public class GraphViewEdit
    extends CompoundEdit
    implements GraphModelEvent.GraphViewChange,
    GraphModelEvent.ExecutableGraphChange {
        protected Object[] cells;
        protected CellView[] context;
        protected CellView[] hidden;
        protected Map attributes;
        protected Object[] visible;
        protected Object[] invisible;

        public GraphViewEdit(Map nested) {
            this(nested, null, null);
            this.attributes = nested;
        }

        public GraphViewEdit(Map attributes, Object[] visible, Object[] invisible) {
            this.attributes = attributes;
            if (attributes != null) {
                this.cells = attributes.keySet().toArray();
                Set ctx = DefaultGraphModel.getEdges(GraphLayoutCache.this.getModel(), this.cells);
                this.context = GraphLayoutCache.this.getMapping(ctx.toArray());
            }
            this.visible = visible;
            this.invisible = invisible;
        }

        public boolean isSignificant() {
            return true;
        }

        public Object getSource() {
            return GraphLayoutCache.this;
        }

        public Object[] getChanged() {
            if (this.attributes != null) {
                return this.attributes.keySet().toArray();
            }
            return null;
        }

        public Object[] getContext() {
            return this.context;
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.execute();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        public void execute() {
            if (this.hidden != null) {
                int i = 0;
                while (i < this.hidden.length) {
                    if (this.hidden[i] != null) {
                        GraphLayoutCache.this.mapping.put(this.hidden[i].getCell(), this.hidden[i]);
                    }
                    ++i;
                }
            }
            if (!GraphLayoutCache.this.rememberCellViews) {
                this.hidden = GraphLayoutCache.this.getMapping(this.invisible);
            }
            boolean updatePorts = GraphLayoutCache.this.setVisibleImpl(this.visible, true) | GraphLayoutCache.this.setVisibleImpl(this.invisible, false);
            Object[] tmp = this.visible;
            this.visible = this.invisible;
            this.invisible = tmp;
            if (this.attributes != null) {
                this.attributes = GraphLayoutCache.this.handleAttributes(this.attributes);
            }
            if (updatePorts) {
                GraphLayoutCache.this.updatePorts();
            }
            if (this.context != null) {
                int i = 0;
                while (i < this.context.length) {
                    if (this.context[i] != null) {
                        this.context[i].refresh(false);
                    }
                    ++i;
                }
            }
            GraphLayoutCache.this.setChanged();
            GraphLayoutCache.this.notifyObservers(this);
        }
    }

    public static class GraphViewLayerEdit
    extends AbstractUndoableEdit
    implements GraphModelEvent.GraphViewChange,
    GraphModelEvent.ExecutableGraphChange {
        public static final int FRONT = -1;
        public static final int BACK = -2;
        protected Object changeSource;
        protected transient Object[] cells;
        protected transient int[] next;
        protected transient int[] prev;
        protected int layer;

        public GraphViewLayerEdit(Object source, Object[] cells, int layer) {
            this.changeSource = source;
            this.cells = cells;
            this.layer = layer;
            this.next = new int[cells.length];
            this.prev = new int[cells.length];
            this.updateNext();
        }

        protected void updateNext() {
            int i = 0;
            while (i < this.next.length) {
                this.next[i] = this.layer;
                ++i;
            }
        }

        public Object getSource() {
            return this.changeSource;
        }

        public Object[] getChanged() {
            return this.cells;
        }

        public Object[] getContext() {
            return null;
        }

        public Map getAttributes() {
            return null;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.updateNext();
            this.execute();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        public void execute() {
            int i = 0;
            while (i < this.cells.length) {
                List list = this.getParentList(this.cells[i]);
                if (list != null) {
                    this.prev[i] = list.indexOf(this.cells[i]);
                    if (this.prev[i] >= 0) {
                        list.remove(this.prev[i]);
                        int n = this.next[i];
                        if (n == -1) {
                            n = list.size();
                        } else if (n == -2) {
                            n = 0;
                        }
                        list.add(n, this.cells[i]);
                        this.next[i] = this.prev[i];
                    }
                }
                ++i;
            }
            this.updateListeners();
        }

        protected void updateListeners() {
            ((GraphLayoutCache)this.changeSource).setChanged();
            ((GraphLayoutCache)this.changeSource).notifyObservers(this);
        }

        protected List getParentList(Object view) {
            if (view instanceof CellView) {
                CellView parent = ((CellView)view).getParentView();
                List list = null;
                if (parent == null) {
                    list = ((GraphLayoutCache)this.changeSource).roots;
                } else if (parent instanceof AbstractCellView) {
                    list = ((AbstractCellView)parent).childViews;
                }
                return list;
            }
            return null;
        }
    }
}

