/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jgraph.graph.GraphModel;

public class ParentMap
implements Serializable {
    protected ArrayList entries = new ArrayList();
    protected Set changedNodes = new HashSet();
    protected Map childCount = new Hashtable();

    public static ParentMap create(GraphModel m, Object[] c, boolean remove, boolean strict) {
        HashSet<Object> cellSet = new HashSet<Object>();
        int i = 0;
        while (i < c.length) {
            cellSet.add(c[i]);
            ++i;
        }
        ParentMap parentMap = new ParentMap();
        int i2 = c.length - 1;
        while (i2 >= 0) {
            Object parent = m.getParent(c[i2]);
            if (parent != null && (!strict || !remove && cellSet.contains(parent))) {
                parentMap.addEntry(c[i2], remove ? null : parent);
            }
            if (remove) {
                while (cellSet.contains(parent)) {
                    parent = m.getParent(parent);
                }
                int j = 0;
                while (j < m.getChildCount(c[i2])) {
                    Object child = m.getChild(c[i2], j);
                    if (!cellSet.contains(child)) {
                        parentMap.addEntry(child, parent);
                    }
                    ++j;
                }
            }
            --i2;
        }
        return parentMap;
    }

    public void addEntry(Object child, Object parent) {
        if (child != null) {
            this.entries.add(new Entry(child, parent));
            this.changedNodes.add(child);
            if (parent != null) {
                this.changedNodes.add(parent);
            }
        }
    }

    public int size() {
        return this.entries.size();
    }

    public Iterator entries() {
        return this.entries.iterator();
    }

    public Set getChangedNodes() {
        return this.changedNodes;
    }

    public ParentMap clone(Map map) {
        ParentMap pm = new ParentMap();
        Iterator it = this.entries();
        while (it.hasNext()) {
            Entry e = (Entry)it.next();
            Object child = map.get(e.getChild());
            Object parent = map.get(e.getParent());
            if (child == null) {
                child = e.getChild();
            }
            if (parent == null) {
                parent = e.getParent();
            }
            if (child == null || parent == null) continue;
            pm.addEntry(child, parent);
        }
        return pm;
    }

    public String toString() {
        String s = String.valueOf(super.toString()) + "\n";
        Iterator it = this.entries();
        while (it.hasNext()) {
            Entry entry = (Entry)it.next();
            s = String.valueOf(s) + " child=" + entry.getChild() + " parent=" + entry.getParent() + "\n";
        }
        return s;
    }

    public class Entry
    implements Serializable {
        protected Object child;
        protected Object parent;

        public Entry(Object child, Object parent) {
            this.child = child;
            this.parent = parent;
        }

        public Object getChild() {
            return this.child;
        }

        public Object getParent() {
            return this.parent;
        }
    }
}

