/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.PortView;

public class PortRenderer
extends JComponent
implements CellViewRenderer,
Serializable {
    protected transient JGraph graph;
    protected transient PortView view;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;

    public PortRenderer() {
        this.setForeground(UIManager.getColor("MenuItem.selectionBackground"));
        this.setBackground(UIManager.getColor("Tree.selectionBorderColor"));
    }

    public Component getRendererComponent(JGraph graph, CellView view, boolean sel, boolean focus, boolean preview) {
        if (view instanceof PortView && graph != null) {
            this.graph = graph;
            this.view = (PortView)view;
            this.hasFocus = focus;
            this.selected = sel;
            this.preview = preview;
            return this;
        }
        return null;
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(this.graph.getBackground());
        g.setXORMode(this.graph.getBackground());
        if (this.preview) {
            g.setColor(this.getBackground());
            g.drawRect(1, 1, d.width - 3, d.height - 3);
            g.drawRect(2, 2, d.width - 5, d.height - 5);
        }
        boolean offset = GraphConstants.getOffset(this.view.getAllAttributes()) != null;
        g.setColor(this.getForeground());
        if (offset) {
            g.fillRect(2, 2, d.width - 3, d.height - 3);
        } else if (!this.preview) {
            g.drawRect(1, 1, d.width - 4, d.height - 4);
        }
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

