/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jgraph.JGraph;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.Port;
import org.jgraph.graph.PortRenderer;
import org.jgraph.graph.VertexView;

public class PortView
extends AbstractCellView {
    protected static int size = 6;
    public static PortRenderer renderer = new PortRenderer();
    protected transient CellView lastParent;

    public PortView(Object cell, JGraph graph, CellMapper mapper) {
        super(cell, graph, mapper);
    }

    public CellView getParentView() {
        CellView parent = super.getParentView();
        if (parent == null) {
            parent = this.lastParent;
        } else {
            this.lastParent = parent;
        }
        return parent;
    }

    public Rectangle2D getBounds() {
        Rectangle2D bounds = this.getAttributes().createRect(this.getLocation(null));
        bounds.setFrame(bounds.getX() - (double)(size / 2), bounds.getY() - (double)(size / 2), bounds.getWidth() + (double)size, bounds.getHeight() + (double)size);
        return bounds;
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public CellHandle getHandle(GraphContext context) {
        return null;
    }

    public Point2D getLocation(EdgeView edge) {
        Port modelAnchor = null;
        if (this.cell instanceof Port) {
            modelAnchor = ((Port)this.cell).getAnchor();
        }
        PortView anchor = (PortView)this.mapper.getMapping(modelAnchor, false);
        Point2D pos = null;
        boolean isAbsolute = GraphConstants.isAbsolute(this.allAttributes);
        Point2D offset = GraphConstants.getOffset(this.allAttributes);
        VertexView vertex = (VertexView)this.getParentView();
        if (vertex != null) {
            if (edge == null && offset == null) {
                pos = vertex.getCenterPoint();
            }
            if (offset != null) {
                double x = offset.getX();
                double y = offset.getY();
                Rectangle2D r = vertex.getBounds();
                if (!isAbsolute) {
                    x = x * (r.getWidth() - 1.0) / 1000.0;
                    y = y * (r.getHeight() - 1.0) / 1000.0;
                }
                pos = anchor != null ? anchor.getLocation(edge) : this.getAttributes().createPoint(r.getX(), r.getY());
                pos = this.getAttributes().createPoint(pos.getX() + x, pos.getY() + y);
            } else if (edge != null) {
                Point2D p1 = this.getNextPoint(edge);
                if (p1 == null) {
                    return vertex.getCenterPoint();
                }
                pos = vertex.getPerimeterPoint(pos, p1);
                if (edge.getPointCount() > 2 && GraphConstants.getRouting(edge.getAllAttributes()) == null && p1 != null) {
                    Rectangle2D r = this.getParentView().getBounds();
                    if (p1.getX() > r.getX() && p1.getX() < r.getX() + r.getWidth()) {
                        pos.setLocation(p1.getX(), pos.getY());
                    } else if (p1.getY() >= r.getY() && p1.getY() < r.getY() + r.getHeight()) {
                        pos.setLocation(pos.getX(), p1.getY());
                    }
                    if (p1.getY() < r.getY()) {
                        pos.setLocation(pos.getX(), r.getY());
                    } else if (p1.getY() > r.getY() + r.getHeight()) {
                        pos.setLocation(pos.getX(), r.getY() + r.getHeight());
                    }
                }
            }
        }
        return pos;
    }

    protected Point2D getNextPoint(EdgeView edge) {
        int n = edge.getPointCount();
        if (n > 1) {
            if (edge.getSource() == this) {
                return this.getEdgePoint(edge, 1);
            }
            if (edge.getTarget() == this) {
                return this.getEdgePoint(edge, n - 2);
            }
        }
        return null;
    }

    protected Point2D getEdgePoint(EdgeView view, int index) {
        VertexView vertex;
        Object obj = view.points.get(index);
        if (obj instanceof Point2D) {
            return (Point2D)obj;
        }
        if (obj instanceof PortView && (vertex = (VertexView)((CellView)obj).getParentView()) != null) {
            return vertex.getCenterPoint();
        }
        return null;
    }
}

