/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexView;

public class VertexRenderer
extends JLabel
implements CellViewRenderer,
Serializable {
    protected boolean hideGroups = true;
    protected transient JGraph graph;
    protected transient VertexView view;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient boolean childrenSelected;
    protected transient Color defaultForeground = UIManager.getColor("Tree.textForeground");
    protected transient Color defaultBackground = UIManager.getColor("Tree.textBackground");
    protected transient Color bordercolor;
    protected transient int borderWidth;
    transient boolean isDoubleBuffered = false;

    public VertexRenderer() {
    }

    public VertexRenderer(boolean hideGroups) {
        this.hideGroups = hideGroups;
    }

    public Component getRendererComponent(JGraph graph, CellView view, boolean sel, boolean focus, boolean preview) {
        this.graph = graph;
        this.isDoubleBuffered = graph.isDoubleBuffered();
        if (view instanceof VertexView) {
            this.view = (VertexView)view;
            this.setComponentOrientation(graph.getComponentOrientation());
            if (graph.getEditingCell() != view.getCell()) {
                String label = graph.convertValueToString(view);
                if (label != null) {
                    this.setText(label.toString());
                } else {
                    this.setText(null);
                }
            } else {
                this.setText(null);
            }
            this.graph = graph;
            this.hasFocus = focus;
            this.childrenSelected = graph.getSelectionModel().isChildrenSelected(view.getCell());
            this.selected = sel;
            this.preview = preview;
            if (this.view.isLeaf() || !this.hideGroups) {
                this.installAttributes(view);
            } else {
                this.setText(null);
                this.setBorder(null);
                this.setOpaque(false);
                this.setIcon(null);
            }
            return this;
        }
        return null;
    }

    protected void installAttributes(CellView view) {
        Color foreground;
        AttributeMap map = view.getAllAttributes();
        this.setIcon(GraphConstants.getIcon(map));
        this.setOpaque(GraphConstants.isOpaque(map));
        this.setBorder(GraphConstants.getBorder(map));
        this.setVerticalAlignment(GraphConstants.getVerticalAlignment(map));
        this.setHorizontalAlignment(GraphConstants.getHorizontalAlignment(map));
        this.setVerticalTextPosition(GraphConstants.getVerticalTextPosition(map));
        this.setHorizontalTextPosition(GraphConstants.getHorizontalTextPosition(map));
        this.bordercolor = GraphConstants.getBorderColor(map);
        this.borderWidth = Math.max(1, Math.round(GraphConstants.getLineWidth(map)));
        if (this.getBorder() == null && this.bordercolor != null) {
            this.setBorder(BorderFactory.createLineBorder(this.bordercolor, this.borderWidth));
        }
        this.setForeground((foreground = GraphConstants.getForeground(map)) != null ? foreground : this.defaultForeground);
        Color background = GraphConstants.getBackground(map);
        this.setBackground(background != null ? background : this.defaultBackground);
        this.setFont(GraphConstants.getFont(map));
    }

    public void paint(Graphics g) {
        try {
            super.paint(g);
            this.paintSelectionBorder(g);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void paintSelectionBorder(Graphics g) {
        ((Graphics2D)g).setStroke(GraphConstants.SELECTION_STROKE);
        if (this.childrenSelected) {
            g.setColor(this.graph.getGridColor());
        } else if (this.hasFocus && this.selected) {
            g.setColor(this.graph.getLockedHandleColor());
        } else if (this.selected) {
            g.setColor(this.graph.getHighlightColor());
        }
        if (this.childrenSelected || this.selected) {
            Dimension d = this.getSize();
            g.drawRect(0, 0, d.width - 1, d.height - 1);
        }
    }

    public Point2D getPerimeterPoint(VertexView view, Point2D source, Point2D p) {
        Rectangle2D bounds = view.getBounds();
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double xCenter = x + width / 2.0;
        double yCenter = y + height / 2.0;
        double dx = p.getX() - xCenter;
        double dy = p.getY() - yCenter;
        double alpha = Math.atan2(dy, dx);
        double xout = 0.0;
        double yout = 0.0;
        double pi = Math.PI;
        double pi2 = 1.5707963267948966;
        double beta = pi2 - alpha;
        double t = Math.atan2(height, width);
        if (alpha < -pi + t || alpha > pi - t) {
            xout = x;
            yout = yCenter - width * Math.tan(alpha) / 2.0;
        } else if (alpha < -t) {
            yout = y;
            xout = xCenter - height * Math.tan(beta) / 2.0;
        } else if (alpha < t) {
            xout = x + width;
            yout = yCenter + width * Math.tan(alpha) / 2.0;
        } else {
            yout = y + height;
            xout = xCenter + height * Math.tan(beta) / 2.0;
        }
        return view.getAttributes().createPoint(xout, yout);
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    public boolean isHideGroups() {
        return this.hideGroups;
    }

    public void setHideGroups(boolean hideGroups) {
        this.hideGroups = hideGroups;
    }
}

