/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jgraph.JGraph;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.plaf.GraphUI;
import org.jgraph.plaf.basic.BasicGraphUI;

public class VertexView
extends AbstractCellView {
    public static VertexRenderer renderer = new VertexRenderer();
    protected Rectangle2D bounds;
    protected Rectangle2D groupBounds = DefaultGraphCell.defaultBounds;
    public static transient int[] defaultCursors = new int[]{6, 8, 7, 10, 11, 4, 9, 5};
    public static transient int[] xCursors;
    public static transient int[] yCursors;

    static {
        int[] nArray = new int[8];
        nArray[0] = 10;
        nArray[2] = 11;
        nArray[3] = 10;
        nArray[4] = 11;
        nArray[5] = 10;
        nArray[7] = 11;
        xCursors = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 8;
        nArray2[1] = 8;
        nArray2[2] = 8;
        nArray2[5] = 9;
        nArray2[6] = 9;
        nArray2[7] = 9;
        yCursors = nArray2;
    }

    public VertexView(Object cell, JGraph graph, CellMapper mapper) {
        super(cell, graph, mapper);
    }

    public void update() {
        super.update();
        this.bounds = GraphConstants.getBounds(this.allAttributes);
        this.groupBounds = null;
    }

    public void childUpdated() {
        super.childUpdated();
        this.groupBounds = null;
    }

    public Rectangle2D getBounds() {
        if (!this.isLeaf()) {
            if (this.groupBounds == null) {
                this.updateGroupBounds();
            }
            return this.groupBounds;
        }
        return this.bounds;
    }

    public Rectangle2D getCachedBounds() {
        return this.bounds;
    }

    public void setCachedBounds(Rectangle2D bounds) {
        this.bounds = bounds;
    }

    protected void updateGroupBounds() {
        CellView[] childViews = this.getChildViews();
        LinkedList<CellView> result = new LinkedList<CellView>();
        int i = 0;
        while (i < childViews.length) {
            if (this.includeInGroupBounds(childViews[i])) {
                result.add(childViews[i]);
            }
            ++i;
        }
        childViews = new CellView[result.size()];
        result.toArray(childViews);
        this.groupBounds = AbstractCellView.getBounds(childViews);
    }

    private boolean includeInGroupBounds(CellView view) {
        if (view instanceof EdgeView) {
            GraphModel model = this.graph.getModel();
            EdgeView edgeView = (EdgeView)view;
            if (edgeView.getCell() instanceof DefaultMutableTreeNode) {
                TreeNode target;
                TreeNode source;
                DefaultMutableTreeNode edge = (DefaultMutableTreeNode)edgeView.getCell();
                if (model.getSource(edge) instanceof TreeNode && ((DefaultMutableTreeNode)(source = (TreeNode)model.getSource(edge)).getParent()).isNodeDescendant(edge)) {
                    return false;
                }
                if (model.getTarget(edge) instanceof TreeNode && ((DefaultMutableTreeNode)(target = (TreeNode)model.getTarget(edge)).getParent()).isNodeDescendant(edge)) {
                    return false;
                }
            }
        }
        return true;
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public CellHandle getHandle(GraphContext context) {
        if (GraphConstants.isSizeable(this.getAllAttributes()) && context.getGraph().isSizeable()) {
            return new SizeHandle(this, context);
        }
        return null;
    }

    public Point2D getCenterPoint() {
        Rectangle2D r = this.getBounds();
        return this.getAttributes().createPoint(r.getCenterX(), r.getCenterY());
    }

    public Point2D getPerimeterPoint(Point2D source, Point2D p) {
        return renderer.getPerimeterPoint(this, source, p);
    }

    public static class SizeHandle
    implements CellHandle,
    Serializable {
        protected transient Image offscreen;
        protected transient Graphics offgraphics;
        protected transient boolean firstDrag = true;
        protected transient JGraph graph;
        protected transient VertexView vertex;
        protected transient CellView[] portViews;
        protected transient Rectangle2D cachedBounds;
        protected transient GraphContext context;
        protected transient Rectangle2D initialBounds;
        protected transient CellView[] contextViews;
        protected transient int index = -1;
        protected transient Rectangle2D[] r = new Rectangle2D[8];
        protected boolean firstOverlayInvocation = true;
        public transient int[] cursors = null;

        public SizeHandle(VertexView vertexview, GraphContext ctx) {
            this.graph = ctx.getGraph();
            this.vertex = vertexview;
            int sizeableAxis = GraphConstants.getSizeableAxis(this.vertex.getAllAttributes());
            this.cursors = sizeableAxis == 1 ? xCursors : (sizeableAxis == 2 ? yCursors : defaultCursors);
            this.portViews = ctx.createTemporaryPortViews();
            this.initialBounds = (Rectangle2D)this.vertex.getBounds().clone();
            this.context = ctx;
            int i = 0;
            while (i < this.r.length) {
                this.r[i] = this.vertex.getAttributes().createRect();
                ++i;
            }
            this.invalidate();
        }

        public boolean isConstrainedSizeEvent(MouseEvent e) {
            GraphUI ui = this.graph.getUI();
            if (ui instanceof BasicGraphUI) {
                return ((BasicGraphUI)ui).isConstrainedMoveEvent(e);
            }
            return false;
        }

        public void paint(Graphics g) {
            this.invalidate();
            g.setColor(this.graph.getHandleColor());
            int i = 0;
            while (i < this.r.length) {
                if (this.cursors[i] != 0) {
                    g.fill3DRect((int)this.r[i].getX(), (int)this.r[i].getY(), (int)this.r[i].getWidth(), (int)this.r[i].getHeight(), true);
                }
                ++i;
            }
        }

        protected void initOffscreen() {
            try {
                Rectangle rect = this.graph.getBounds();
                this.offscreen = new BufferedImage(rect.width, rect.height, 1);
                this.offgraphics = this.offscreen.getGraphics();
                this.offgraphics.setClip(0, 0, rect.width, rect.height);
                this.offgraphics.setColor(this.graph.getBackground());
                this.offgraphics.fillRect(0, 0, rect.width, rect.height);
                this.graph.getUI().paint(this.offgraphics, this.graph);
            }
            catch (Error e) {
                this.offscreen = null;
                this.offgraphics = null;
            }
        }

        public void overlay(Graphics g) {
            if (!this.firstOverlayInvocation) {
                if (this.cachedBounds != null) {
                    g.setColor(Color.black);
                    Rectangle2D tmp = this.graph.toScreen((Rectangle2D)this.cachedBounds.clone());
                    g.drawRect((int)tmp.getX(), (int)tmp.getY(), (int)tmp.getWidth() - 2, (int)tmp.getHeight() - 2);
                } else if (!this.initialBounds.equals(this.vertex.getBounds())) {
                    Graphics2D g2 = (Graphics2D)g;
                    AffineTransform oldTransform = g2.getTransform();
                    g2.scale(this.graph.getScale(), this.graph.getScale());
                    this.graph.getUI().paintCell(g, this.vertex, this.vertex.getBounds(), true);
                    if (this.contextViews != null) {
                        int i = 0;
                        while (i < this.contextViews.length) {
                            this.graph.getUI().paintCell(g, this.contextViews[i], this.contextViews[i].getBounds(), true);
                            ++i;
                        }
                    }
                    g2.setTransform(oldTransform);
                    if (this.portViews != null && this.graph.isPortsVisible()) {
                        this.graph.getUI().paintPorts(g, this.portViews);
                    }
                }
            }
            this.firstOverlayInvocation = false;
        }

        public void mouseMoved(MouseEvent event) {
            if (this.vertex != null) {
                int i = 0;
                while (i < this.r.length) {
                    if (this.r[i].contains(event.getPoint())) {
                        this.graph.setCursor(new Cursor(this.cursors[i]));
                        event.consume();
                        return;
                    }
                    ++i;
                }
            }
        }

        public void mousePressed(MouseEvent event) {
            if (!this.graph.isSizeable()) {
                return;
            }
            int i = 0;
            while (i < this.r.length) {
                if (this.r[i].contains(event.getPoint()) && this.cursors[i] != 0) {
                    HashSet<Object> set = new HashSet<Object>();
                    set.add(this.vertex.getCell());
                    this.contextViews = this.context.createTemporaryContextViews(set);
                    CellView[] all = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                    if (all.length >= BasicGraphUI.MAXHANDLES) {
                        this.cachedBounds = (Rectangle2D)this.initialBounds.clone();
                    }
                    event.consume();
                    this.index = i;
                    return;
                }
                ++i;
            }
        }

        public void mouseDragged(MouseEvent event) {
            Rectangle2D t;
            Graphics g;
            if (this.firstDrag && this.graph.isDoubleBuffered() && this.cachedBounds == null) {
                this.initOffscreen();
                this.firstDrag = false;
            }
            Rectangle2D dirty = null;
            Graphics graphics = g = this.offgraphics != null ? this.offgraphics : this.graph.getGraphics();
            if (this.index == -1) {
                return;
            }
            Rectangle2D newBounds = this.computeBounds(event);
            g.setColor(this.graph.getForeground());
            g.setXORMode(this.graph.getBackground().darker());
            this.overlay(g);
            if (this.offgraphics != null) {
                dirty = this.graph.toScreen((Rectangle2D)this.vertex.getBounds().clone());
                t = this.graph.toScreen(AbstractCellView.getBounds(this.contextViews));
                if (t != null) {
                    dirty.add(t);
                }
            }
            if (this.cachedBounds != null) {
                this.cachedBounds = newBounds;
            } else {
                CellView[] all = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                int i = 0;
                while (i < all.length) {
                    CellView orig = this.graph.getGraphLayoutCache().getMapping(all[i].getCell(), false);
                    AttributeMap origAttr = (AttributeMap)orig.getAllAttributes().clone();
                    all[i].setAttributes(origAttr);
                    all[i].refresh(false);
                    ++i;
                }
                this.vertex.setBounds(newBounds);
                if (this.vertex != null) {
                    this.graph.getGraphLayoutCache().update(this.vertex);
                }
                if (this.contextViews != null) {
                    this.graph.getGraphLayoutCache().update(this.contextViews);
                }
            }
            this.overlay(g);
            if (this.offscreen != null) {
                dirty.add(this.graph.toScreen((Rectangle2D)this.vertex.getBounds().clone()));
                t = this.graph.toScreen(AbstractCellView.getBounds(this.contextViews));
                if (t != null) {
                    dirty.add(t);
                }
                int size = 2;
                dirty.setFrame(dirty.getX() - (double)size, dirty.getY() - (double)size, dirty.getWidth() + (double)(size * 2), dirty.getHeight() + (double)(size * 2));
                double sx1 = Math.max(0.0, dirty.getX());
                double sy1 = Math.max(0.0, dirty.getY());
                double sx2 = sx1 + dirty.getWidth();
                double sy2 = sy1 + dirty.getHeight();
                this.graph.getGraphics().drawImage(this.offscreen, (int)sx1, (int)sy1, (int)sx2, (int)sy2, (int)sx1, (int)sy1, (int)sx2, (int)sy2, this.graph);
            }
        }

        protected Rectangle2D computeBounds(MouseEvent event) {
            double left = this.initialBounds.getX();
            double right = this.initialBounds.getX() + this.initialBounds.getWidth() - 1.0;
            double top = this.initialBounds.getY();
            double bottom = this.initialBounds.getY() + this.initialBounds.getHeight() - 1.0;
            Point2D p = this.graph.fromScreen(this.graph.snap((Point2D)event.getPoint().clone()));
            p.setLocation(Math.max(0.0, p.getX()), Math.max(0.0, p.getY()));
            if (this.index > 4) {
                bottom = p.getY();
            } else if (this.index < 3) {
                top = p.getY();
            }
            if (this.index == 0 || this.index == 3 || this.index == 5) {
                left = p.getX();
            } else if (this.index == 2 || this.index == 4 || this.index == 7) {
                right = p.getX();
            }
            double width = right - left;
            double height = bottom - top;
            if (this.isConstrainedSizeEvent(event)) {
                if (this.index == 3 || this.index == 4 || this.index == 5) {
                    height = width;
                } else if (this.index == 1 || this.index == 6 || this.index == 2 || this.index == 7) {
                    width = height;
                } else {
                    height = width;
                    top = bottom - height;
                }
            }
            if (width < 0.0) {
                left += width;
                width = Math.abs(width);
            }
            if (height < 0.0) {
                top += height;
                height = Math.abs(height);
            }
            return this.vertex.getAttributes().createRect(left, top, width + 1.0, height + 1.0);
        }

        public void mouseReleased(MouseEvent e) {
            if (this.index != -1) {
                this.cachedBounds = this.computeBounds(e);
                this.vertex.setBounds(this.cachedBounds);
                Object[] views = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                Map attributes = GraphConstants.createAttributes(views, null);
                this.graph.getGraphLayoutCache().edit(attributes, null, null, null);
            }
            e.consume();
            this.cachedBounds = null;
            this.initialBounds = null;
            this.firstDrag = true;
        }

        private void invalidate() {
            Rectangle2D tmp = this.graph.getCellBounds(this.vertex.getCell());
            if (tmp != null) {
                tmp = (Rectangle2D)tmp.clone();
                this.graph.toScreen(tmp);
                int handlesize = this.graph.getHandleSize();
                int s2 = 2 * handlesize;
                double left = tmp.getX() - (double)handlesize;
                double top = tmp.getY() - (double)handlesize;
                double w2 = tmp.getX() + tmp.getWidth() / 2.0 - (double)handlesize;
                double h2 = tmp.getY() + tmp.getHeight() / 2.0 - (double)handlesize;
                double right = tmp.getX() + tmp.getWidth() - (double)handlesize;
                double bottom = tmp.getY() + tmp.getHeight() - (double)handlesize;
                this.r[0].setFrame(left, top, s2, s2);
                this.r[1].setFrame(w2, top, s2, s2);
                this.r[2].setFrame(right, top, s2, s2);
                this.r[3].setFrame(left, h2, s2, s2);
                this.r[4].setFrame(right, h2, s2, s2);
                this.r[5].setFrame(left, bottom, s2, s2);
                this.r[6].setFrame(w2, bottom, s2, s2);
                this.r[7].setFrame(right, bottom, s2, s2);
            }
        }
    }
}

