/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.plaf.basic;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import javax.swing.plaf.UIResource;

public class BasicGraphTransferable
implements Transferable,
UIResource,
Serializable {
    private static DataFlavor[] htmlFlavors;
    private static DataFlavor[] stringFlavors;
    private static DataFlavor[] plainFlavors;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        try {
            htmlFlavors = new DataFlavor[3];
            BasicGraphTransferable.htmlFlavors[0] = new DataFlavor("text/html;class=java.lang.String");
            BasicGraphTransferable.htmlFlavors[1] = new DataFlavor("text/html;class=java.io.Reader");
            BasicGraphTransferable.htmlFlavors[2] = new DataFlavor("text/html;charset=unicode;class=java.io.InputStream");
            plainFlavors = new DataFlavor[3];
            BasicGraphTransferable.plainFlavors[0] = new DataFlavor("text/plain;class=java.lang.String");
            BasicGraphTransferable.plainFlavors[1] = new DataFlavor("text/plain;class=java.io.Reader");
            BasicGraphTransferable.plainFlavors[2] = new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream");
            stringFlavors = new DataFlavor[2];
            BasicGraphTransferable.stringFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String");
            BasicGraphTransferable.stringFlavors[1] = DataFlavor.stringFlavor;
        }
        catch (ClassNotFoundException cle) {
            System.err.println("error initializing javax.swing.plaf.basic.BasicTranserable");
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] richerFlavors = this.getRicherFlavors();
        int nRicher = richerFlavors != null ? richerFlavors.length : 0;
        int nHTML = this.isHTMLSupported() ? htmlFlavors.length : 0;
        int nPlain = this.isPlainSupported() ? plainFlavors.length : 0;
        int nString = this.isPlainSupported() ? stringFlavors.length : 0;
        int nFlavors = nRicher + nHTML + nPlain + nString;
        DataFlavor[] flavors = new DataFlavor[nFlavors];
        int nDone = 0;
        if (nRicher > 0) {
            System.arraycopy(richerFlavors, 0, flavors, nDone, nRicher);
            nDone += nRicher;
        }
        if (nHTML > 0) {
            System.arraycopy(htmlFlavors, 0, flavors, nDone, nHTML);
            nDone += nHTML;
        }
        if (nPlain > 0) {
            System.arraycopy(plainFlavors, 0, flavors, nDone, nPlain);
            nDone += nPlain;
        }
        if (nString > 0) {
            System.arraycopy(stringFlavors, 0, flavors, nDone, nString);
            nDone += nString;
        }
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] flavors = this.getTransferDataFlavors();
        int i = 0;
        while (i < flavors.length) {
            if (flavors[i].equals(flavor)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isRicherFlavor(flavor)) {
            return this.getRicherData(flavor);
        }
        if (this.isHTMLFlavor(flavor)) {
            String data = this.getHTMLData();
            data = data == null ? "" : data;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(flavor.getRepresentationClass())) {
                return data;
            }
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.io.Reader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz2.equals(flavor.getRepresentationClass())) {
                return new StringReader(data);
            }
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("java.io.InputStream");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz3.equals(flavor.getRepresentationClass())) {
                return new StringBufferInputStream(data);
            }
        } else if (this.isPlainFlavor(flavor)) {
            String data = this.getPlainData();
            data = data == null ? "" : data;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(flavor.getRepresentationClass())) {
                return data;
            }
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("java.io.Reader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz4.equals(flavor.getRepresentationClass())) {
                return new StringReader(data);
            }
            Class<?> clazz5 = class$2;
            if (clazz5 == null) {
                try {
                    clazz5 = class$2 = Class.forName("java.io.InputStream");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz5.equals(flavor.getRepresentationClass())) {
                return new StringBufferInputStream(data);
            }
        } else if (this.isStringFlavor(flavor)) {
            String data = this.getPlainData();
            data = data == null ? "" : data;
            return data;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    protected boolean isRicherFlavor(DataFlavor flavor) {
        DataFlavor[] richerFlavors = this.getRicherFlavors();
        int nFlavors = richerFlavors != null ? richerFlavors.length : 0;
        int i = 0;
        while (i < nFlavors) {
            if (richerFlavors[i].equals(flavor)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected DataFlavor[] getRicherFlavors() {
        return null;
    }

    protected Object getRicherData(DataFlavor flavor) throws UnsupportedFlavorException {
        return null;
    }

    protected boolean isHTMLFlavor(DataFlavor flavor) {
        DataFlavor[] flavors = htmlFlavors;
        int i = 0;
        while (i < flavors.length) {
            if (flavors[i].equals(flavor)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isHTMLSupported() {
        return false;
    }

    protected String getHTMLData() {
        return null;
    }

    protected boolean isPlainFlavor(DataFlavor flavor) {
        DataFlavor[] flavors = plainFlavors;
        int i = 0;
        while (i < flavors.length) {
            if (flavors[i].equals(flavor)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isPlainSupported() {
        return false;
    }

    protected String getPlainData() {
        return null;
    }

    protected boolean isStringFlavor(DataFlavor flavor) {
        DataFlavor[] flavors = stringFlavors;
        int i = 0;
        while (i < flavors.length) {
            if (flavors[i].equals(flavor)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

