/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.EdgeRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphCellEditor;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphSelectionModel;
import org.jgraph.graph.GraphTransferable;
import org.jgraph.graph.ParentMap;
import org.jgraph.plaf.GraphUI;
import org.jgraph.plaf.basic.BasicGraphDropTargetListener;

public class BasicGraphUI
extends GraphUI
implements Serializable {
    public static final boolean DNDPREVIEW = System.getProperty("java.version").compareTo("1.4.0") < 0 || System.getProperty("java.version").compareTo("1.4.0") > 0;
    public static int SCROLLBORDER = 18;
    public static float SCROLLSTEP = 0.05f;
    public static int MAXCELLS = 20;
    public static int MAXHANDLES = 20;
    public static int MAXCLIPCELLS = 20;
    protected Dimension preferredMinSize;
    protected JGraph graph;
    protected GraphLayoutCache graphLayoutCache;
    protected GraphCellEditor cellEditor;
    protected boolean stopEditingInCompleteEditing;
    protected CellRendererPane rendererPane;
    protected Dimension preferredSize;
    protected boolean validCachedPreferredSize;
    protected GraphModel graphModel;
    protected GraphSelectionModel graphSelectionModel;
    protected CellHandle handle;
    protected BasicMarqueeHandler marquee;
    protected Component editingComponent;
    protected CellView focus;
    protected Object editingCell;
    protected boolean editorHasDifferentSize;
    protected Point insertionLocation;
    protected int dropAction = 0;
    protected boolean snapSelectedView = false;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseListener mouseListener;
    protected KeyListener keyListener;
    protected ComponentListener componentListener;
    protected CellEditorListener cellEditorListener = this.createCellEditorListener();
    protected GraphSelectionListener graphSelectionListener;
    protected GraphModelListener graphModelListener;
    protected Observer graphViewObserver;
    protected TransferHandler defaultTransferHandler;
    protected GraphDropTargetListener defaultDropTargetListener;

    public static ComponentUI createUI(JComponent x) {
        return new BasicGraphUI();
    }

    protected void setModel(GraphModel model) {
        this.cancelEditing(this.graph);
        if (this.graphModel != null && this.graphModelListener != null) {
            this.graphModel.removeGraphModelListener(this.graphModelListener);
        }
        this.graphModel = model;
        if (this.graphModel != null && this.graphModelListener != null) {
            this.graphModel.addGraphModelListener(this.graphModelListener);
        }
        if (this.graphModel != null) {
            this.updateSize();
        }
    }

    protected void setGraphLayoutCache(GraphLayoutCache view) {
        this.cancelEditing(this.graph);
        if (this.graphLayoutCache != null && this.graphViewObserver != null) {
            this.graphLayoutCache.deleteObserver(this.graphViewObserver);
        }
        this.graphLayoutCache = view;
        if (this.graphLayoutCache != null && this.graphViewObserver != null) {
            this.graphLayoutCache.addObserver(this.graphViewObserver);
        }
        this.updateSize();
    }

    protected void setMarquee(BasicMarqueeHandler marqueeHandler) {
        this.marquee = marqueeHandler;
    }

    protected void setSelectionModel(GraphSelectionModel newLSM) {
        this.cancelEditing(this.graph);
        if (this.graphSelectionListener != null && this.graphSelectionModel != null) {
            this.graphSelectionModel.removeGraphSelectionListener(this.graphSelectionListener);
        }
        this.graphSelectionModel = newLSM;
        if (this.graphSelectionModel != null && this.graphSelectionListener != null) {
            this.graphSelectionModel.addGraphSelectionListener(this.graphSelectionListener);
        }
        if (this.graph != null) {
            this.graph.repaint();
        }
    }

    public CellHandle getHandle(JGraph graph) {
        return this.handle;
    }

    protected Object getFocusedCell() {
        if (this.focus != null) {
            return this.focus.getCell();
        }
        return null;
    }

    public Dimension2D getPreferredSize(JGraph graph, CellView view) {
        if (view != null) {
            boolean focus;
            Component component;
            boolean icon;
            Object cell = view.getCell();
            String valueStr = graph.convertValueToString(cell);
            boolean label = valueStr != null && valueStr.length() > 0;
            boolean bl = icon = GraphConstants.getIcon(view.getAllAttributes()) != null;
            if ((label || icon) && (component = view.getRendererComponent(graph, focus = this.getFocusedCell() == cell && graph.hasFocus(), false, false)) != null) {
                graph.add(component);
                component.validate();
                return component.getPreferredSize();
            }
            Rectangle2D bounds = view.getBounds();
            return new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
        }
        return null;
    }

    public Point getInsertionLocation() {
        return this.insertionLocation;
    }

    public void setInsertionLocation(Point p) {
        this.insertionLocation = p;
    }

    public void selectCellsForEvent(JGraph graph, Object[] cells, MouseEvent event) {
        this.selectCellsForEvent(cells, event);
    }

    public void selectCellsForEvent(Object[] cells, MouseEvent event) {
        if (cells == null) {
            return;
        }
        if (this.isToggleSelectionEvent(event)) {
            int i = 0;
            while (i < cells.length) {
                this.toggleSelectionCellForEvent(cells[i], event);
                ++i;
            }
        } else if (this.isAddToSelectionEvent(event)) {
            this.graph.addSelectionCells(cells);
        } else {
            this.graph.setSelectionCells(cells);
        }
    }

    public void selectCellForEvent(Object cell, MouseEvent event) {
        if (this.isToggleSelectionEvent(event)) {
            this.toggleSelectionCellForEvent(cell, event);
        } else if (this.isAddToSelectionEvent(event)) {
            this.graph.addSelectionCell(cell);
        } else {
            this.graph.setSelectionCell(cell);
        }
    }

    protected void toggleSelectionCellForEvent(Object cell, MouseEvent event) {
        if (this.graph.isCellSelected(cell)) {
            this.graph.removeSelectionCell(cell);
        } else {
            this.graph.addSelectionCell(cell);
        }
    }

    public boolean isAddToSelectionEvent(MouseEvent e) {
        return e.isShiftDown();
    }

    public boolean isToggleSelectionEvent(MouseEvent event) {
        return event.isControlDown();
    }

    public boolean isForceMarqueeEvent(MouseEvent event) {
        if (this.marquee != null) {
            return this.marquee.isForceMarqueeEvent(event);
        }
        return false;
    }

    public boolean isConstrainedMoveEvent(MouseEvent event) {
        if (event != null) {
            return event.isShiftDown();
        }
        return false;
    }

    public boolean isEditing(JGraph graph) {
        return this.editingComponent != null;
    }

    public boolean stopEditing(JGraph graph) {
        if (this.editingComponent != null && this.cellEditor.stopCellEditing()) {
            this.completeEditing(false, false, true);
            return true;
        }
        return false;
    }

    public void cancelEditing(JGraph graph) {
        if (this.editingComponent != null) {
            this.completeEditing(false, true, false);
        }
    }

    public void startEditingAtCell(JGraph graph, Object cell) {
        graph.scrollCellToVisible(cell);
        if (cell != null) {
            this.startEditing(cell, null);
        }
    }

    public Object getEditingCell(JGraph graph) {
        return this.editingCell;
    }

    public void installUI(JComponent c) {
        if (c == null) {
            throw new NullPointerException("null component passed to BasicGraphUI.installUI()");
        }
        this.graph = (JGraph)c;
        this.marquee = this.graph.getMarqueeHandler();
        this.prepareForUIInstall();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.installComponents();
        this.completeUIInstall();
    }

    protected void prepareForUIInstall() {
        this.stopEditingInCompleteEditing = true;
        this.preferredSize = new Dimension();
        this.setGraphLayoutCache(this.graph.getGraphLayoutCache());
        this.setModel(this.graph.getModel());
    }

    protected void completeUIInstall() {
        this.setSelectionModel(this.graph.getSelectionModel());
        this.updateSize();
    }

    protected void installDefaults() {
        if (this.graph.getBackground() == null || this.graph.getBackground() instanceof UIResource) {
            this.graph.setBackground(UIManager.getColor("Tree.background"));
        }
        if (this.graph.getFont() == null || this.graph.getFont() instanceof UIResource) {
            this.graph.setFont(UIManager.getFont("Tree.font"));
        }
        this.graph.setMarqueeColor(UIManager.getColor("Table.gridColor"));
        this.graph.setHandleColor(UIManager.getColor("MenuItem.selectionBackground"));
        this.graph.setLockedHandleColor(UIManager.getColor("MenuItem.background"));
        this.graph.setGridColor(UIManager.getColor("Tree.selectionBackground"));
        this.graph.setOpaque(true);
    }

    protected void installListeners() {
        TransferHandler th = this.graph.getTransferHandler();
        if (th == null || th instanceof UIResource) {
            this.defaultTransferHandler = this.createTransferHandler();
            this.graph.setTransferHandler(this.defaultTransferHandler);
        }
        if (this.graphLayoutCache != null) {
            this.graphViewObserver = this.createGraphViewObserver();
            this.graphLayoutCache.addObserver(this.graphViewObserver);
        }
        DropTarget dropTarget = this.graph.getDropTarget();
        try {
            if (dropTarget != null) {
                this.defaultDropTargetListener = new GraphDropTargetListener();
                dropTarget.addDropTargetListener(this.defaultDropTargetListener);
            }
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener()) != null) {
            this.graph.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            this.graph.addMouseListener(this.mouseListener);
            if (this.mouseListener instanceof MouseMotionListener) {
                this.graph.addMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
            }
        }
        if ((this.keyListener = this.createKeyListener()) != null) {
            this.graph.addKeyListener(this.keyListener);
        }
        if ((this.graphModelListener = this.createGraphModelListener()) != null && this.graphModel != null) {
            this.graphModel.addGraphModelListener(this.graphModelListener);
        }
        if ((this.graphSelectionListener = this.createGraphSelectionListener()) != null && this.graphSelectionModel != null) {
            this.graphSelectionModel.addGraphSelectionListener(this.graphSelectionListener);
        }
    }

    protected void installKeyboardActions() {
        InputMap km = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.graph, 1, km);
        km = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.graph, 0, km);
        SwingUtilities.replaceUIActionMap(this.graph, this.createActionMap());
    }

    InputMap getInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)UIManager.get("Tree.ancestorInputMap");
        }
        if (condition == 0) {
            return (InputMap)UIManager.get("Tree.focusInputMap");
        }
        return null;
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("selectPrevious", new GraphIncrementAction(1, "selectPrevious"));
        map.put("selectPreviousChangeLead", new GraphIncrementAction(1, "selectPreviousLead"));
        map.put("selectPreviousExtendSelection", new GraphIncrementAction(1, "selectPreviousExtendSelection"));
        map.put("selectParent", new GraphIncrementAction(4, "selectParent"));
        map.put("selectParentChangeLead", new GraphIncrementAction(4, "selectParentChangeLead"));
        map.put("selectNext", new GraphIncrementAction(3, "selectNext"));
        map.put("selectNextChangeLead", new GraphIncrementAction(3, "selectNextLead"));
        map.put("selectNextExtendSelection", new GraphIncrementAction(3, "selectNextExtendSelection"));
        map.put("selectChild", new GraphIncrementAction(2, "selectChild"));
        map.put("selectChildChangeLead", new GraphIncrementAction(2, "selectChildChangeLead"));
        map.put("cancel", new GraphCancelEditingAction("cancel"));
        map.put("startEditing", new GraphEditAction("startEditing"));
        map.put("selectAll", new GraphSelectAllAction("selectAll", true));
        map.put("clearSelection", new GraphSelectAllAction("clearSelection", false));
        return map;
    }

    protected void installComponents() {
        this.rendererPane = this.createCellRendererPane();
        if (this.rendererPane != null) {
            this.graph.add(this.rendererPane);
        }
    }

    protected TransferHandler createTransferHandler() {
        return new GraphTransferHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    protected GraphSelectionListener createGraphSelectionListener() {
        return new GraphSelectionHandler();
    }

    protected CellEditorListener createCellEditorListener() {
        return new CellEditorHandler();
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler();
    }

    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane();
    }

    protected Observer createGraphViewObserver() {
        return new GraphViewObserver();
    }

    protected GraphModelListener createGraphModelListener() {
        return new GraphModelHandler();
    }

    public void uninstallUI(JComponent c) {
        this.cancelEditing(this.graph);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.completeUIUninstall();
    }

    protected void completeUIUninstall() {
        this.graphLayoutCache = null;
        this.rendererPane = null;
        this.componentListener = null;
        this.propertyChangeListener = null;
        this.keyListener = null;
        this.setSelectionModel(null);
        this.graph = null;
        this.graphModel = null;
        this.graphSelectionModel = null;
        this.graphSelectionListener = null;
    }

    protected void uninstallListeners() {
        TransferHandler th = this.graph.getTransferHandler();
        if (th == this.defaultTransferHandler) {
            this.graph.setTransferHandler(null);
        }
        if (this.graphViewObserver != null) {
            this.graphLayoutCache.deleteObserver(this.graphViewObserver);
        }
        if (this.graph.getDropTarget() != null && this.defaultDropTargetListener != null) {
            this.graph.getDropTarget().removeDropTargetListener(this.defaultDropTargetListener);
        }
        if (this.componentListener != null) {
            this.graph.removeComponentListener(this.componentListener);
        }
        if (this.propertyChangeListener != null) {
            this.graph.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.mouseListener != null) {
            this.graph.removeMouseListener(this.mouseListener);
            if (this.mouseListener instanceof MouseMotionListener) {
                this.graph.removeMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
            }
        }
        if (this.keyListener != null) {
            this.graph.removeKeyListener(this.keyListener);
        }
        if (this.graphModel != null && this.graphModelListener != null) {
            this.graphModel.removeGraphModelListener(this.graphModelListener);
        }
        if (this.graphSelectionListener != null && this.graphSelectionModel != null) {
            this.graphSelectionModel.removeGraphSelectionListener(this.graphSelectionListener);
        }
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.graph, null);
        SwingUtilities.replaceUIInputMap(this.graph, 1, null);
        SwingUtilities.replaceUIInputMap(this.graph, 0, null);
    }

    protected void uninstallComponents() {
        if (this.rendererPane != null) {
            this.graph.remove(this.rendererPane);
        }
    }

    public void paint(Graphics g, JComponent c) {
        if (this.graph != c) {
            throw new InternalError("BasicGraphUI cannot paint " + c.toString() + "; " + this.graph + " was expected.");
        }
        Graphics2D g2 = (Graphics2D)g;
        Rectangle tmp = g.getClipBounds();
        Rectangle2D.Double paintBounds = new Rectangle2D.Double(((RectangularShape)tmp).getX(), ((RectangularShape)tmp).getY(), ((RectangularShape)tmp).getWidth(), ((RectangularShape)tmp).getHeight());
        Rectangle2D real = this.graph.fromScreen(new Rectangle2D.Double(((RectangularShape)paintBounds).getX(), ((RectangularShape)paintBounds).getY(), ((RectangularShape)paintBounds).getWidth(), ((RectangularShape)paintBounds).getHeight()));
        this.paintBackground(g);
        AffineTransform at = g2.getTransform();
        if (this.graph.isAntiAliased()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        double scale = this.graph.getScale();
        g2.scale(scale, scale);
        CellView[] views = this.graphLayoutCache.getRoots();
        int i = 0;
        while (i < views.length) {
            Rectangle2D bounds = views[i].getBounds();
            if (bounds != null && real != null && bounds.intersects(real)) {
                this.paintCell(g, views[i], bounds, false);
            }
            ++i;
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2.setTransform(at);
        this.paintForeground(g);
        if (this.handle != null) {
            this.handle.paint(g);
        }
        g.setColor(this.graph.getMarqueeColor());
        g.setXORMode(this.graph.getBackground());
        if (this.marquee != null) {
            this.marquee.paint(g);
        }
        g.setPaintMode();
        if (this.rendererPane != null) {
            this.rendererPane.removeAll();
        }
    }

    public void paintCell(Graphics g, CellView view, Rectangle2D bounds, boolean preview) {
        if (view != null && bounds != null) {
            boolean bfocus = view == this.focus;
            boolean sel = this.graph.isCellSelected(view.getCell());
            Component component = view.getRendererComponent(this.graph, sel, bfocus, preview);
            this.rendererPane.paintComponent(g, component, this.graph, (int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight(), true);
        }
        if (!view.isLeaf()) {
            CellView[] children = view.getChildViews();
            int i = 0;
            while (i < children.length) {
                this.paintCell(g, children[i], children[i].getBounds(), preview);
                ++i;
            }
        }
    }

    protected void paintBackground(Graphics g) {
        if (this.graph.isGridVisible()) {
            this.paintGrid(this.graph.getGridSize(), g, g.getClipBounds());
        }
    }

    protected void paintGrid(double gs, Graphics g, Rectangle2D r) {
        Rectangle rr = g.getClipBounds();
        double xl = rr.x;
        double yt = rr.y;
        double xr = xl + (double)rr.width;
        double yb = yt + (double)rr.height;
        double sgs = Math.max(2.0, gs * this.graph.getScale());
        int xs = (int)(Math.floor(xl / sgs) * sgs);
        int xe = (int)(Math.ceil(xr / sgs) * sgs);
        int ys = (int)(Math.floor(yt / sgs) * sgs);
        int ye = (int)(Math.ceil(yb / sgs) * sgs);
        g.setColor(this.graph.getGridColor());
        switch (this.graph.getGridMode()) {
            case 1: {
                int cs = sgs > 16.0 ? 2 : (sgs < 8.0 ? 0 : 1);
                double x = xs;
                while (x <= (double)xe) {
                    double y = ys;
                    while (y <= (double)ye) {
                        int ix = (int)Math.round(x);
                        int iy = (int)Math.round(y);
                        g.drawLine(ix - cs, iy, ix + cs, iy);
                        g.drawLine(ix, iy - cs, ix, iy + cs);
                        y += sgs;
                    }
                    x += sgs;
                }
                break;
            }
            case 2: {
                xe += (int)Math.ceil(sgs);
                ye += (int)Math.ceil(sgs);
                double x = xs;
                while (x <= (double)xe) {
                    int ix = (int)Math.round(x);
                    g.drawLine(ix, ys, ix, ye);
                    x += sgs;
                }
                double y = ys;
                while (y <= (double)ye) {
                    int iy = (int)Math.round(y);
                    g.drawLine(xs, iy, xe, iy);
                    y += sgs;
                }
                break;
            }
            default: {
                double x = xs;
                while (x <= (double)xe) {
                    double y = ys;
                    while (y <= (double)ye) {
                        int ix = (int)Math.round(x);
                        int iy = (int)Math.round(y);
                        g.drawLine(ix, iy, ix, iy);
                        y += sgs;
                    }
                    x += sgs;
                }
                break block0;
            }
        }
    }

    protected void paintForeground(Graphics g) {
        if (this.graph.isPortsVisible()) {
            this.paintPorts(g, this.graphLayoutCache.getPorts());
        }
    }

    public void paintPorts(Graphics g, CellView[] ports) {
        if (ports != null) {
            Rectangle r = g.getClipBounds();
            int i = 0;
            while (i < ports.length) {
                if (ports[i] != null) {
                    Rectangle2D tmp = ports[i].getBounds();
                    Rectangle2D.Double bounds = new Rectangle2D.Double(tmp.getX(), tmp.getY(), tmp.getWidth(), tmp.getHeight());
                    Point2D center = this.graph.toScreen(new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()));
                    bounds.setFrame(center.getX() - ((RectangularShape)bounds).getWidth() / 2.0, center.getY() - ((RectangularShape)bounds).getHeight() / 2.0, ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight());
                    if (r == null || bounds.intersects(r)) {
                        this.paintCell(g, ports[i], bounds, false);
                    }
                }
                ++i;
            }
        }
    }

    protected void updateHandle() {
        if (this.graphLayoutCache != null) {
            Object[] cells = this.graphLayoutCache.order(this.graph.getSelectionCells());
            this.handle = cells != null && cells.length > 0 ? this.createHandle(this.createContext(this.graph, cells)) : null;
        }
    }

    protected GraphContext createContext(JGraph graph, Object[] cells) {
        return new GraphContext(graph, cells);
    }

    public CellHandle createHandle(GraphContext context) {
        if (context != null && !context.isEmpty() && this.graph.isEnabled()) {
            return new RootHandle(context);
        }
        return null;
    }

    public void updateSize() {
        this.validCachedPreferredSize = false;
        this.graph.graphDidChange();
        this.updateHandle();
    }

    protected void updateCachedPreferredSize() {
        Rectangle2D size = AbstractCellView.getBounds(this.graphLayoutCache.getRoots());
        if (size == null) {
            size = new Rectangle2D.Double();
        }
        Point2D.Double psize = new Point2D.Double(size.getX() + size.getWidth(), size.getY() + size.getHeight());
        Dimension d = this.graph.getMinimumSize();
        Point min = d != null ? this.graph.toScreen(new Point(d.width, d.height)) : new Point(0, 0);
        Point2D scaled = this.graph.toScreen(psize);
        this.preferredSize = new Dimension((int)Math.max(((Point2D)min).getX(), scaled.getX()), (int)Math.max(((Point2D)min).getY(), scaled.getY()));
        Insets in = this.graph.getInsets();
        if (in != null) {
            this.preferredSize.setSize(this.preferredSize.getWidth() + (double)in.left + (double)in.right, this.preferredSize.getHeight() + (double)in.top + (double)in.bottom);
        }
        this.validCachedPreferredSize = true;
    }

    public void setPreferredMinSize(Dimension newSize) {
        this.preferredMinSize = newSize;
    }

    public Dimension getPreferredMinSize() {
        if (this.preferredMinSize == null) {
            return null;
        }
        return new Dimension(this.preferredMinSize);
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension pSize = this.getPreferredMinSize();
        if (!this.validCachedPreferredSize) {
            this.updateCachedPreferredSize();
        }
        if (this.graph != null) {
            if (pSize != null) {
                return new Dimension(Math.max(pSize.width, this.preferredSize.width), Math.max(pSize.height, this.preferredSize.height));
            }
            return new Dimension(this.preferredSize.width, this.preferredSize.height);
        }
        if (pSize != null) {
            return pSize;
        }
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize(JComponent c) {
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    public Dimension getMaximumSize(JComponent c) {
        if (this.graph != null) {
            return this.getPreferredSize(this.graph);
        }
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    protected void completeEditing() {
        if (this.graph.getInvokesStopCellEditing() && this.stopEditingInCompleteEditing && this.editingComponent != null) {
            this.cellEditor.stopCellEditing();
        }
        this.completeEditing(false, true, false);
    }

    protected void completeEditing(boolean messageStop, boolean messageCancel, boolean messageGraph) {
        if (this.stopEditingInCompleteEditing && this.editingComponent != null) {
            Component oldComponent = this.editingComponent;
            Object oldCell = this.editingCell;
            GraphCellEditor oldEditor = this.cellEditor;
            Object newValue = oldEditor.getCellEditorValue();
            boolean requestFocus = this.graph != null && (this.graph.hasFocus() || this.editingComponent.hasFocus());
            this.editingCell = null;
            this.editingComponent = null;
            if (messageStop) {
                oldEditor.stopCellEditing();
            } else if (messageCancel) {
                oldEditor.cancelCellEditing();
            }
            this.graph.remove(oldComponent);
            if (requestFocus) {
                this.graph.requestFocus();
            }
            if (messageGraph) {
                this.graphLayoutCache.valueForCellChanged(oldCell, newValue);
            }
            this.updateSize();
            if (oldEditor != null && this.cellEditorListener != null) {
                oldEditor.removeCellEditorListener(this.cellEditorListener);
            }
            this.cellEditor = null;
        }
    }

    protected boolean startEditing(Object cell, MouseEvent event) {
        this.completeEditing();
        if (this.graph.isCellEditable(cell)) {
            CellView tmp = this.graphLayoutCache.getMapping(cell, false);
            this.cellEditor = tmp.getEditor();
            this.editingComponent = this.cellEditor.getGraphCellEditorComponent(this.graph, cell, this.graph.isCellSelected(cell));
            if (this.cellEditor.isCellEditable(event)) {
                Rectangle2D cellBounds = this.graph.getCellBounds(cell);
                this.editingCell = cell;
                Dimension editorSize = this.editingComponent.getPreferredSize();
                this.graph.add(this.editingComponent);
                Point2D p = this.graph.toScreen(new Point2D.Double(cellBounds.getX(), cellBounds.getY()));
                if (this.graphLayoutCache.getMapping(cell, false) instanceof EdgeView) {
                    EdgeView edgeView = (EdgeView)this.graphLayoutCache.getMapping(cell, false);
                    EdgeRenderer er = edgeView.getEdgeRenderer();
                    p = er.getLabelPosition(edgeView);
                    p.setLocation(p.getX() - ((Dimension2D)editorSize).getWidth() / 2.0, p.getY() - ((Dimension2D)editorSize).getHeight() / 2.0);
                    this.graph.toScreen(p);
                }
                this.editingComponent.setBounds((int)p.getX(), (int)p.getY(), (int)((Dimension2D)editorSize).getWidth(), (int)((Dimension2D)editorSize).getHeight());
                this.editingCell = cell;
                this.editingComponent.validate();
                if (this.cellEditorListener == null) {
                    this.cellEditorListener = this.createCellEditorListener();
                }
                if (this.cellEditor != null && this.cellEditorListener != null) {
                    this.cellEditor.addCellEditorListener(this.cellEditorListener);
                }
                Rectangle visRect = this.graph.getVisibleRect();
                this.graph.paintImmediately((int)p.getX(), (int)p.getY(), (int)(((RectangularShape)visRect).getWidth() + ((RectangularShape)visRect).getX() - cellBounds.getX()), (int)((Dimension2D)editorSize).getHeight());
                if (this.cellEditor.shouldSelectCell(event)) {
                    this.stopEditingInCompleteEditing = false;
                    try {
                        this.graph.setSelectionCell(cell);
                    }
                    catch (Exception e) {
                        System.err.println("Editing exception: " + e);
                    }
                    this.stopEditingInCompleteEditing = true;
                }
                if (event instanceof MouseEvent) {
                    Point componentPoint = SwingUtilities.convertPoint(this.graph, new Point(event.getX(), event.getY()), this.editingComponent);
                    Component activeComponent = SwingUtilities.getDeepestComponentAt(this.editingComponent, componentPoint.x, componentPoint.y);
                    if (activeComponent != null) {
                        new MouseInputHandler(this.graph, activeComponent, event);
                    }
                }
                return true;
            }
            this.editingComponent = null;
        }
        return false;
    }

    public static void autoscroll(JGraph graph, Point p) {
        Rectangle view = graph.getBounds();
        if (graph.getParent() instanceof JViewport) {
            view = ((JViewport)graph.getParent()).getViewRect();
        }
        if (view.contains(p)) {
            Point target = new Point(p);
            int dx = (int)((float)graph.getWidth() * SCROLLSTEP);
            int dy = (int)((float)graph.getHeight() * SCROLLSTEP);
            if (target.x - view.x < SCROLLBORDER) {
                target.x -= dx;
            }
            if (target.y - view.y < SCROLLBORDER) {
                target.y -= dy;
            }
            if (view.x + view.width - target.x < SCROLLBORDER) {
                target.x += dx;
            }
            if (view.y + view.height - target.y < SCROLLBORDER) {
                target.y += dy;
            }
            graph.scrollPointToVisible(target);
        }
    }

    public void insertCells(Object[] cells, Map viewAttributeMap, ConnectionSet cs, ParentMap pm, boolean clone, int dx, int dy) {
        if (clone) {
            Map cellMap = this.graph.cloneCells(cells);
            viewAttributeMap = GraphConstants.replaceKeys(cellMap, viewAttributeMap);
            AttributeMap.translate(viewAttributeMap.values(), dx, dy);
            cs = cs.clone(cellMap);
            pm = pm.clone(cellMap);
            int i = 0;
            while (i < cells.length) {
                cells[i] = cellMap.get(cells[i]);
                ++i;
            }
        }
        this.graphLayoutCache.insert(cells, viewAttributeMap, cs, pm, null);
    }

    public boolean isSnapSelectedView() {
        return this.snapSelectedView;
    }

    public void setSnapSelectedView(boolean snapSelectedView) {
        this.snapSelectedView = snapSelectedView;
    }

    public class ComponentHandler
    extends ComponentAdapter
    implements ActionListener {
        protected Timer timer;
        protected JScrollBar scrollBar;

        public void componentMoved(ComponentEvent e) {
            if (this.timer == null) {
                JScrollPane scrollPane = this.getScrollPane();
                if (scrollPane == null) {
                    BasicGraphUI.this.updateSize();
                } else {
                    this.scrollBar = scrollPane.getVerticalScrollBar();
                    if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                        this.scrollBar = scrollPane.getHorizontalScrollBar();
                        if (this.scrollBar != null && this.scrollBar.getValueIsAdjusting()) {
                            this.startTimer();
                        } else {
                            BasicGraphUI.this.updateSize();
                        }
                    } else {
                        this.startTimer();
                    }
                }
            }
        }

        protected void startTimer() {
            if (this.timer == null) {
                this.timer = new Timer(200, this);
                this.timer.setRepeats(true);
            }
            this.timer.start();
        }

        protected JScrollPane getScrollPane() {
            Container c = BasicGraphUI.this.graph.getParent();
            while (c != null && !(c instanceof JScrollPane)) {
                c = c.getParent();
            }
            if (c instanceof JScrollPane) {
                return (JScrollPane)c;
            }
            return null;
        }

        public void actionPerformed(ActionEvent ae) {
            if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                if (this.timer != null) {
                    this.timer.stop();
                }
                BasicGraphUI.this.updateSize();
                this.timer = null;
                this.scrollBar = null;
            }
        }
    }

    public class GraphModelHandler
    implements GraphModelListener,
    Serializable {
        public void graphChanged(GraphModelEvent e) {
            if (BasicGraphUI.this.graphLayoutCache != null) {
                BasicGraphUI.this.graphLayoutCache.graphChanged(e.getChange());
            }
            Object[] inserted = e.getChange().getInserted();
            Object[] removed = e.getChange().getRemoved();
            if (inserted != null && inserted.length > 0) {
                BasicGraphUI.this.focus = BasicGraphUI.this.graphLayoutCache.getMapping(inserted[0], false);
            }
            if (removed != null && removed.length > 0) {
                int i = 0;
                while (i < removed.length && BasicGraphUI.this.focus != null) {
                    if (removed[i] == BasicGraphUI.this.focus.getCell()) {
                        BasicGraphUI.this.focus = null;
                    }
                    ++i;
                }
                BasicGraphUI.this.graph.getSelectionModel().removeSelectionCells(removed);
            }
            BasicGraphUI.this.updateSize();
            if (inserted != null && inserted.length > 0 && BasicGraphUI.this.graph.isSelectNewCells()) {
                ArrayList<Object> toSelect = new ArrayList<Object>();
                int i = 0;
                while (i < inserted.length) {
                    if (BasicGraphUI.this.graphModel.getParent(inserted[i]) == null && BasicGraphUI.this.graphLayoutCache.isVisible(inserted[i])) {
                        toSelect.add(inserted[i]);
                    }
                    ++i;
                }
                BasicGraphUI.this.graph.setSelectionCells(toSelect.toArray());
                BasicGraphUI.this.graph.requestFocus();
            }
        }
    }

    public class GraphViewObserver
    implements Observer,
    Serializable {
        public void update(Observable o, Object arg) {
            BasicGraphUI.this.updateSize();
        }
    }

    public class GraphSelectionHandler
    implements GraphSelectionListener,
    Serializable {
        public void valueChanged(GraphSelectionEvent event) {
            BasicGraphUI.this.updateHandle();
            Object[] cells = event.getCells();
            if (cells != null && cells.length <= MAXCLIPCELLS) {
                Rectangle2D r = BasicGraphUI.this.graph.toScreen(BasicGraphUI.this.graph.getCellBounds(cells));
                if (r != null) {
                    int hsize = BasicGraphUI.this.graph.getHandleSize();
                    BasicGraphUI.this.updateHandle();
                    BasicGraphUI.this.graph.repaint((int)r.getX() - hsize, (int)r.getY() - hsize, (int)r.getWidth() + 2 * hsize, (int)r.getHeight() + 2 * hsize);
                }
            } else {
                BasicGraphUI.this.graph.repaint();
            }
        }
    }

    public class CellEditorHandler
    implements CellEditorListener,
    Serializable {
        public void editingStopped(ChangeEvent e) {
            BasicGraphUI.this.completeEditing(false, false, true);
        }

        public void editingCanceled(ChangeEvent e) {
            BasicGraphUI.this.completeEditing(false, false, false);
        }
    }

    public class KeyHandler
    extends KeyAdapter
    implements Serializable {
        protected Action repeatKeyAction;
        protected boolean isKeyDown;

        public void keyPressed(KeyEvent e) {
            if (BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.hasFocus() && BasicGraphUI.this.graph.isEnabled()) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
                if (BasicGraphUI.this.graph.getConditionForKeyStroke(keyStroke) == 0) {
                    ActionListener listener = BasicGraphUI.this.graph.getActionForKeyStroke(keyStroke);
                    this.repeatKeyAction = listener instanceof Action ? (Action)listener : null;
                } else {
                    this.repeatKeyAction = null;
                    if (keyStroke.getKeyCode() == 27) {
                        if (BasicGraphUI.this.marquee != null) {
                            BasicGraphUI.this.marquee.mouseReleased(null);
                        }
                        if (BasicGraphUI.this.mouseListener != null) {
                            BasicGraphUI.this.mouseListener.mouseReleased(null);
                        }
                        BasicGraphUI.this.updateHandle();
                        BasicGraphUI.this.graph.repaint();
                    }
                }
                if (this.isKeyDown && this.repeatKeyAction != null) {
                    this.repeatKeyAction.actionPerformed(new ActionEvent(BasicGraphUI.this.graph, 1001, ""));
                    e.consume();
                } else {
                    this.isKeyDown = true;
                }
            }
        }

        public void keyReleased(KeyEvent e) {
            this.isKeyDown = false;
        }
    }

    public class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener,
    Serializable {
        protected CellView cell;
        protected Object handler;
        protected transient Cursor previousCursor = null;

        public void mousePressed(MouseEvent e) {
            this.handler = null;
            if (!e.isConsumed() && BasicGraphUI.this.graph.isEnabled()) {
                BasicGraphUI.this.graph.requestFocus();
                int s = BasicGraphUI.this.graph.getTolerance();
                Rectangle2D r = BasicGraphUI.this.graph.fromScreen(new Rectangle2D.Double(e.getX() - s, e.getY() - s, 2 * s, 2 * s));
                Point2D point = BasicGraphUI.this.graph.fromScreen(new Point2D.Double(e.getX(), e.getY()));
                BasicGraphUI.this.focus = BasicGraphUI.this.focus != null && BasicGraphUI.this.focus.intersects(BasicGraphUI.this.graph.getGraphics(), r) ? BasicGraphUI.this.focus : null;
                this.cell = BasicGraphUI.this.graph.getNextViewAt(BasicGraphUI.this.focus, point.getX(), point.getY());
                if (BasicGraphUI.this.focus == null) {
                    BasicGraphUI.this.focus = this.cell;
                }
                BasicGraphUI.this.completeEditing();
                if (!BasicGraphUI.this.isForceMarqueeEvent(e)) {
                    if (e.getClickCount() == BasicGraphUI.this.graph.getEditClickCount() && BasicGraphUI.this.focus != null && BasicGraphUI.this.focus.isLeaf() && BasicGraphUI.this.focus.getParentView() == null) {
                        this.handleEditTrigger(BasicGraphUI.this.focus.getCell(), e);
                        e.consume();
                        this.cell = null;
                    } else if (!BasicGraphUI.this.isToggleSelectionEvent(e)) {
                        if (BasicGraphUI.this.handle != null) {
                            BasicGraphUI.this.handle.mousePressed(e);
                            this.handler = BasicGraphUI.this.handle;
                        }
                        if (!e.isConsumed() && this.cell != null && !BasicGraphUI.this.graph.isCellSelected(this.cell)) {
                            BasicGraphUI.this.selectCellForEvent(this.cell.getCell(), e);
                            BasicGraphUI.this.focus = this.cell;
                            if (BasicGraphUI.this.handle != null) {
                                BasicGraphUI.this.handle.mousePressed(e);
                                this.handler = BasicGraphUI.this.handle;
                            }
                            e.consume();
                            this.cell = null;
                        }
                    }
                }
                if (!(e.isConsumed() || BasicGraphUI.this.isToggleSelectionEvent(e) && BasicGraphUI.this.focus != null || BasicGraphUI.this.marquee == null)) {
                    BasicGraphUI.this.marquee.mousePressed(e);
                    this.handler = BasicGraphUI.this.marquee;
                }
            }
        }

        protected void handleEditTrigger(Object cell, MouseEvent e) {
            BasicGraphUI.this.graph.scrollCellToVisible(cell);
            if (cell != null) {
                BasicGraphUI.this.startEditing(cell, e);
            }
        }

        public void mouseDragged(MouseEvent e) {
            BasicGraphUI.autoscroll(BasicGraphUI.this.graph, e.getPoint());
            if (this.handler != null && this.handler == BasicGraphUI.this.marquee) {
                BasicGraphUI.this.marquee.mouseDragged(e);
            } else if (this.handler == null && !BasicGraphUI.this.isEditing(BasicGraphUI.this.graph) && BasicGraphUI.this.focus != null) {
                if (!BasicGraphUI.this.graph.isCellSelected(BasicGraphUI.this.focus.getCell())) {
                    BasicGraphUI.this.selectCellForEvent(BasicGraphUI.this.focus.getCell(), e);
                    this.cell = null;
                }
                if (BasicGraphUI.this.handle != null) {
                    BasicGraphUI.this.handle.mousePressed(e);
                }
                this.handler = BasicGraphUI.this.handle;
            }
            if (BasicGraphUI.this.handle != null && this.handler == BasicGraphUI.this.handle) {
                BasicGraphUI.this.handle.mouseDragged(e);
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (this.previousCursor == null) {
                this.previousCursor = BasicGraphUI.this.graph.getCursor();
            }
            if (BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.isEnabled()) {
                if (BasicGraphUI.this.marquee != null) {
                    BasicGraphUI.this.marquee.mouseMoved(e);
                }
                if (BasicGraphUI.this.handle != null) {
                    BasicGraphUI.this.handle.mouseMoved(e);
                }
                if (!e.isConsumed() && this.previousCursor != null) {
                    BasicGraphUI.this.graph.setCursor(this.previousCursor);
                    this.previousCursor = null;
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void mouseReleased(MouseEvent e) {
            try {
                if (e != null && !e.isConsumed()) {
                    if (this.handler == BasicGraphUI.this.marquee && BasicGraphUI.this.marquee != null) {
                        BasicGraphUI.this.marquee.mouseReleased(e);
                    } else if (this.handler == BasicGraphUI.this.handle && BasicGraphUI.this.handle != null) {
                        BasicGraphUI.this.handle.mouseReleased(e);
                    }
                    if (this.isDescendant(this.cell, BasicGraphUI.this.focus) && e.getModifiers() != 0) {
                        this.cell = BasicGraphUI.this.focus;
                    }
                    if (!e.isConsumed() && this.cell != null) {
                        Object tmp = this.cell.getCell();
                        boolean wasSelected = BasicGraphUI.this.graph.isCellSelected(tmp);
                        BasicGraphUI.this.selectCellForEvent(tmp, e);
                        BasicGraphUI.this.focus = this.cell;
                        this.postProcessSelection(e, tmp, wasSelected);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.handler = null;
                this.cell = null;
                throw throwable;
            }
            {
                Object var4_6 = null;
                this.handler = null;
                this.cell = null;
                return;
            }
        }

        protected void postProcessSelection(MouseEvent e, Object cell, boolean wasSelected) {
            if (wasSelected && BasicGraphUI.this.graph.isCellSelected(cell)) {
                Object parent = cell;
                Object nextParent = null;
                while ((nextParent = BasicGraphUI.this.graphModel.getParent(parent)) != null && BasicGraphUI.this.graphLayoutCache.isVisible(nextParent)) {
                    parent = nextParent;
                }
                BasicGraphUI.this.selectCellForEvent(parent, e);
                BasicGraphUI.this.focus = BasicGraphUI.this.graphLayoutCache.getMapping(parent, false);
            }
        }

        protected boolean isDescendant(CellView parentView, CellView childView) {
            Object child;
            if (parentView == null || childView == null) {
                return false;
            }
            Object parent = parentView.getCell();
            Object ancestor = child = childView.getCell();
            do {
                if (ancestor != parent) continue;
                return true;
            } while ((ancestor = BasicGraphUI.this.graphModel.getParent(ancestor)) != null);
            return false;
        }
    }

    public class RootHandle
    implements CellHandle,
    Serializable {
        protected transient double _mouseToViewDelta_x = 0.0;
        protected transient double _mouseToViewDelta_y = 0.0;
        protected transient Image offscreen;
        protected transient Graphics offgraphics;
        protected transient boolean firstDrag = true;
        protected transient CellView[] views;
        protected transient CellView[] contextViews;
        protected transient CellView[] portViews;
        protected transient Rectangle2D cachedBounds;
        protected transient Point2D initialLocation;
        protected transient CellHandle[] handles;
        protected transient Point2D start = null;
        protected transient Point2D last;
        protected transient Point2D snapStart;
        protected transient Point2D snapLast;
        protected boolean isMoving = false;
        protected boolean isDragging = false;
        protected transient CellHandle activeHandle = null;
        protected transient GraphContext context;
        protected boolean isContextVisible = true;
        protected boolean blockPaint = false;
        protected transient ConnectionSet disconnect = null;

        public RootHandle(GraphContext ctx) {
            this.context = ctx;
            if (!ctx.isEmpty()) {
                Object[] cells;
                this.views = ctx.createTemporaryCellViews();
                Rectangle2D tmpBounds = BasicGraphUI.this.graph.toScreen(BasicGraphUI.this.graph.getCellBounds(ctx.getCells()));
                if (ctx.getDescendantCount() < MAXCELLS) {
                    this.contextViews = ctx.createTemporaryContextViews();
                    this.initialLocation = BasicGraphUI.this.graph.toScreen(this.getInitialLocation(ctx.getCells()));
                } else {
                    this.cachedBounds = tmpBounds;
                }
                if (this.initialLocation == null) {
                    this.initialLocation = new Point2D.Double(tmpBounds.getX(), tmpBounds.getY());
                }
                if ((cells = ctx.getCells()).length < MAXHANDLES) {
                    this.handles = new CellHandle[this.views.length];
                    int i = 0;
                    while (i < this.views.length) {
                        this.handles[i] = this.views[i].getHandle(ctx);
                        ++i;
                    }
                    this.portViews = ctx.createTemporaryPortViews();
                }
            }
        }

        protected Point2D getInitialLocation(Object[] cells) {
            if (cells != null && cells.length > 0) {
                Rectangle2D ret = BasicGraphUI.this.graph.getCellBounds(cells[0]);
                ret = (Rectangle2D)ret.clone();
                int i = 1;
                while (i < cells.length) {
                    if (BasicGraphUI.this.graphModel.isEdge(cells[i])) {
                        CellView cellView = BasicGraphUI.this.graphLayoutCache.getMapping(cells[i], false);
                        if (cellView instanceof EdgeView) {
                            Point2D pt;
                            EdgeView edgeView = (EdgeView)cellView;
                            if (edgeView.getSource() == null) {
                                pt = edgeView.getPoint(0);
                                Rectangle2D.union(ret, new Rectangle2D.Double(pt.getX(), pt.getY(), 0.0, 0.0), ret);
                            }
                            if (edgeView.getTarget() == null) {
                                pt = edgeView.getPoint(edgeView.getPointCount() - 1);
                                Rectangle2D.union(ret, new Rectangle2D.Double(pt.getX(), pt.getY(), 0.0, 0.0), ret);
                            }
                        }
                    } else {
                        Rectangle2D r = BasicGraphUI.this.graph.getCellBounds(cells[i]);
                        Rectangle2D.union(ret, r, ret);
                    }
                    ++i;
                }
                if (ret != null) {
                    return new Point2D.Double(ret.getX(), ret.getY());
                }
            }
            return null;
        }

        public GraphContext getContext() {
            return this.context;
        }

        public void paint(Graphics g) {
            if (this.handles != null && this.handles.length < MAXHANDLES) {
                int i = 0;
                while (i < this.handles.length) {
                    if (this.handles[i] != null) {
                        this.handles[i].paint(g);
                    }
                    ++i;
                }
            }
            this.blockPaint = true;
        }

        public void overlay(Graphics g) {
            if (this.isDragging && !DNDPREVIEW) {
                return;
            }
            if (this.cachedBounds != null) {
                g.setColor(Color.black);
                g.drawRect((int)this.cachedBounds.getX(), (int)this.cachedBounds.getY(), (int)this.cachedBounds.getWidth() - 2, (int)this.cachedBounds.getHeight() - 2);
            } else {
                int i;
                Graphics2D g2 = (Graphics2D)g;
                AffineTransform oldTransform = g2.getTransform();
                g2.scale(BasicGraphUI.this.graph.getScale(), BasicGraphUI.this.graph.getScale());
                if (this.views != null) {
                    i = 0;
                    while (i < this.views.length) {
                        BasicGraphUI.this.paintCell(g, this.views[i], this.views[i].getBounds(), true);
                        ++i;
                    }
                }
                if (this.contextViews != null && this.isContextVisible) {
                    i = 0;
                    while (i < this.contextViews.length) {
                        BasicGraphUI.this.paintCell(g, this.contextViews[i], this.contextViews[i].getBounds(), true);
                        ++i;
                    }
                }
                g2.setTransform(oldTransform);
                if (this.portViews != null && BasicGraphUI.this.graph.isPortsVisible()) {
                    BasicGraphUI.this.paintPorts(g, this.portViews);
                }
            }
        }

        public void mouseMoved(MouseEvent event) {
            if (!event.isConsumed() && this.handles != null) {
                int i = this.handles.length - 1;
                while (i >= 0 && !event.isConsumed()) {
                    if (this.handles[i] != null) {
                        this.handles[i].mouseMoved(event);
                    }
                    --i;
                }
            }
        }

        public void mousePressed(MouseEvent event) {
            if (!event.isConsumed() && BasicGraphUI.this.graph.isMoveable()) {
                Point screenPoint;
                Point2D pt;
                CellView view;
                if (this.handles != null) {
                    int i = this.handles.length - 1;
                    while (i >= 0) {
                        if (this.handles[i] != null) {
                            this.handles[i].mousePressed(event);
                            if (event.isConsumed()) {
                                this.activeHandle = this.handles[i];
                                return;
                            }
                        }
                        --i;
                    }
                }
                if (this.views != null && (view = this.findViewForPoint(pt = BasicGraphUI.this.graph.fromScreen((Point2D)(screenPoint = event.getPoint()).clone()))) != null) {
                    if (BasicGraphUI.this.snapSelectedView) {
                        Rectangle2D bounds = view.getBounds();
                        this.start = BasicGraphUI.this.graph.toScreen(new Point2D.Double(bounds.getX(), bounds.getY()));
                        this.snapStart = BasicGraphUI.this.graph.snap((Point2D)this.start.clone());
                        this._mouseToViewDelta_x = ((Point2D)screenPoint).getX() - this.start.getX();
                        this._mouseToViewDelta_y = ((Point2D)screenPoint).getY() - this.start.getY();
                    } else {
                        this.snapStart = BasicGraphUI.this.graph.snap((Point2D)screenPoint.clone());
                        this._mouseToViewDelta_x = this.snapStart.getX() - ((Point2D)screenPoint).getX();
                        this._mouseToViewDelta_y = this.snapStart.getY() - ((Point2D)screenPoint).getY();
                        this.start = (Point2D)this.snapStart.clone();
                    }
                    this.last = (Point2D)this.start.clone();
                    this.snapLast = (Point2D)this.snapStart.clone();
                    this.isContextVisible = this.contextViews != null && this.contextViews.length < MAXCELLS && (!event.isControlDown() || !BasicGraphUI.this.graph.isCloneable());
                    event.consume();
                }
            }
        }

        protected CellView findViewForPoint(Point2D pt) {
            double snap = BasicGraphUI.this.graph.getTolerance();
            Rectangle2D.Double r = new Rectangle2D.Double(pt.getX() - snap, pt.getY() - snap, 2.0 * snap, 2.0 * snap);
            int i = 0;
            while (i < this.views.length) {
                if (this.views[i].intersects(BasicGraphUI.this.graph.getGraphics(), r)) {
                    return this.views[i];
                }
                ++i;
            }
            return null;
        }

        protected void startDragging(MouseEvent event) {
            this.isDragging = true;
            if (BasicGraphUI.this.graph.isDragEnabled()) {
                int action = event.isControlDown() && BasicGraphUI.this.graph.isCloneable() ? 1 : 2;
                TransferHandler th = BasicGraphUI.this.graph.getTransferHandler();
                BasicGraphUI.this.setInsertionLocation(event.getPoint());
                try {
                    th.exportAsDrag(BasicGraphUI.this.graph, event, action);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected void initOffscreen() {
            try {
                Rectangle rect = BasicGraphUI.this.graph.getBounds();
                this.offscreen = new BufferedImage(rect.width, rect.height, 1);
                this.offgraphics = this.offscreen.getGraphics();
                this.offgraphics.setClip(0, 0, (int)rect.getWidth(), (int)rect.getHeight());
                this.offgraphics.setColor(BasicGraphUI.this.graph.getBackground());
                this.offgraphics.fillRect(0, 0, (int)rect.getWidth(), (int)rect.getHeight());
                BasicGraphUI.this.graph.getUI().paint(this.offgraphics, BasicGraphUI.this.graph);
            }
            catch (Error e) {
                this.offscreen = null;
                this.offgraphics = null;
            }
        }

        public void mouseDragged(MouseEvent event) {
            boolean constrained = BasicGraphUI.this.isConstrainedMoveEvent(event);
            Rectangle2D dirty = null;
            if (this.firstDrag && BasicGraphUI.this.graph.isDoubleBuffered() && this.cachedBounds == null) {
                this.initOffscreen();
                this.firstDrag = false;
            }
            if (event != null && !event.isConsumed()) {
                if (this.activeHandle != null) {
                    this.activeHandle.mouseDragged(event);
                } else if (this.start != null) {
                    Point2D snapCurrent;
                    Graphics g = this.offgraphics != null ? this.offgraphics : BasicGraphUI.this.graph.getGraphics();
                    Point ep = event.getPoint();
                    Point2D.Double point = new Point2D.Double(ep.getX() - this._mouseToViewDelta_x, ep.getY() - this._mouseToViewDelta_y);
                    Point2D current = snapCurrent = BasicGraphUI.this.graph.snap(point);
                    int thresh = BasicGraphUI.this.graph.getMinimumMove();
                    double dx = current.getX() - this.start.getX();
                    double dy = current.getY() - this.start.getY();
                    if (this.isMoving || Math.abs(dx) > (double)thresh || Math.abs(dy) > (double)thresh) {
                        boolean overlayed = false;
                        this.isMoving = true;
                        if (this.disconnect == null && BasicGraphUI.this.graph.isDisconnectOnMove()) {
                            this.disconnect = this.context.disconnect(BasicGraphUI.this.graphLayoutCache.getAllDescendants(this.views));
                        }
                        double totDx = current.getX() - this.start.getX();
                        double totDy = current.getY() - this.start.getY();
                        dx = current.getX() - this.last.getX();
                        dy = current.getY() - this.last.getY();
                        if (constrained && this.cachedBounds == null) {
                            if (Math.abs(totDx) < Math.abs(totDy)) {
                                dx = 0.0;
                                dy = totDy;
                            } else {
                                dx = totDx;
                                dy = 0.0;
                            }
                        } else if (!BasicGraphUI.this.graph.isMoveBelowZero() && this.last != null && this.initialLocation != null && this.start != null) {
                            if (this.initialLocation.getX() + totDx < 0.0) {
                                dx = this.start.getX() - this.last.getX() - this.initialLocation.getX();
                            }
                            if (this.initialLocation.getY() + totDy < 0.0) {
                                dy = this.start.getY() - this.last.getY() - this.initialLocation.getY();
                            }
                        }
                        double scale = BasicGraphUI.this.graph.getScale();
                        dx = (int)(dx / scale);
                        dy = (int)(dy / scale);
                        g.setColor(BasicGraphUI.this.graph.getForeground());
                        g.setXORMode(BasicGraphUI.this.graph.getBackground().darker());
                        if (BasicGraphUI.this.graph.isDragEnabled() && !this.isDragging) {
                            this.startDragging(event);
                        }
                        if (dx != 0.0 || dy != 0.0) {
                            Rectangle2D t;
                            if (!(this.snapLast.equals(this.snapStart) || this.offscreen == null && this.blockPaint)) {
                                this.overlay(g);
                                overlayed = true;
                            }
                            this.isContextVisible = (!event.isControlDown() || !BasicGraphUI.this.graph.isCloneable()) && this.contextViews != null && this.contextViews.length < MAXCELLS;
                            this.blockPaint = false;
                            if (this.offscreen != null) {
                                dirty = BasicGraphUI.this.graph.toScreen(AbstractCellView.getBounds(this.views));
                                t = BasicGraphUI.this.graph.toScreen(AbstractCellView.getBounds(this.contextViews));
                                if (t != null) {
                                    dirty.add(t);
                                }
                            }
                            if (constrained && this.cachedBounds == null) {
                                CellView[] all = BasicGraphUI.this.graphLayoutCache.getAllDescendants(this.views);
                                int i = 0;
                                while (i < all.length) {
                                    CellView orig = BasicGraphUI.this.graphLayoutCache.getMapping(all[i].getCell(), false);
                                    AttributeMap attr = orig.getAllAttributes();
                                    all[i].setAttributes((AttributeMap)attr.clone());
                                    all[i].refresh(false);
                                    ++i;
                                }
                            }
                            if (this.cachedBounds != null) {
                                this.cachedBounds.setFrame(this.cachedBounds.getX() + dx * scale, this.cachedBounds.getY() + dy * scale, this.cachedBounds.getWidth(), this.cachedBounds.getHeight());
                            } else {
                                GraphLayoutCache.translateViews(this.views, dx, dy);
                                if (this.views != null) {
                                    BasicGraphUI.this.graphLayoutCache.update(this.views);
                                }
                                if (this.contextViews != null) {
                                    BasicGraphUI.this.graphLayoutCache.update(this.contextViews);
                                }
                            }
                            if (!snapCurrent.equals(this.snapStart)) {
                                this.overlay(g);
                                overlayed = true;
                            }
                            if (constrained) {
                                this.last = (Point2D)this.start.clone();
                            }
                            this.last.setLocation(this.last.getX() + dx * scale, this.last.getY() + dy * scale);
                            this.snapLast = snapCurrent;
                            if (overlayed && this.offscreen != null) {
                                dirty.add(BasicGraphUI.this.graph.toScreen(AbstractCellView.getBounds(this.views)));
                                t = BasicGraphUI.this.graph.toScreen(AbstractCellView.getBounds(this.contextViews));
                                if (t != null) {
                                    dirty.add(t);
                                }
                                dirty.setFrame(dirty.getX() - 2.0, dirty.getY() - 2.0, dirty.getWidth() + 4.0, dirty.getHeight() + 4.0);
                                double sx1 = Math.max(0.0, dirty.getX());
                                double sy1 = Math.max(0.0, dirty.getY());
                                double sx2 = sx1 + dirty.getWidth();
                                double sy2 = sy1 + dirty.getHeight();
                                if (this.isDragging && !DNDPREVIEW) {
                                    return;
                                }
                                BasicGraphUI.this.graph.getGraphics().drawImage(this.offscreen, (int)sx1, (int)sy1, (int)sx2, (int)sy2, (int)sx1, (int)sy1, (int)sx2, (int)sy2, BasicGraphUI.this.graph);
                            }
                        }
                    }
                }
            } else if (event == null) {
                BasicGraphUI.this.graph.repaint();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void mouseReleased(MouseEvent event) {
            try {
                block12: {
                    try {
                        if (event == null || event.isConsumed()) break block12;
                        if (this.activeHandle != null) {
                            this.activeHandle.mouseReleased(event);
                            this.activeHandle = null;
                        } else if (this.isMoving && !event.getPoint().equals(this.start)) {
                            if (this.cachedBounds != null) {
                                double dx = (double)event.getX() - this.start.getX();
                                double dy = (double)event.getY() - this.start.getY();
                                Point2D tmp = BasicGraphUI.this.graph.fromScreen(new Point2D.Double(dx, dy));
                                GraphLayoutCache.translateViews(this.views, tmp.getX(), tmp.getY());
                            }
                            Object[] all = BasicGraphUI.this.graphLayoutCache.getAllDescendants(this.views);
                            if (event.isControlDown() && BasicGraphUI.this.graph.isCloneable()) {
                                Object[] cells = BasicGraphUI.this.graphLayoutCache.order(BasicGraphUI.this.graph.getDescendantList(this.context.getCells()));
                                ConnectionSet cs = ConnectionSet.create(BasicGraphUI.this.graphModel, cells, false);
                                ParentMap pm = ParentMap.create(BasicGraphUI.this.graphModel, cells, false, true);
                                Map attributes = GraphConstants.createAttributes(all, null);
                                BasicGraphUI.this.insertCells(cells, attributes, cs, pm, true, 0, 0);
                            } else if (BasicGraphUI.this.graph.isMoveable()) {
                                Map attributes = GraphConstants.createAttributes(all, null);
                                Iterator it = attributes.values().iterator();
                                BasicGraphUI.this.graph.getGraphLayoutCache().edit(attributes, this.disconnect, null, null);
                            }
                            event.consume();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                Object var7_14 = null;
                this.initialLocation = null;
                this.isDragging = false;
                this.disconnect = null;
                this.offscreen = null;
                this.firstDrag = true;
                this.start = null;
                return;
            }
            catch (Throwable throwable) {
                Object var7_13 = null;
                this.initialLocation = null;
                this.isDragging = false;
                this.disconnect = null;
                this.offscreen = null;
                this.firstDrag = true;
                this.start = null;
                throw throwable;
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener,
    Serializable {
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getSource() == BasicGraphUI.this.graph) {
                String changeName = event.getPropertyName();
                if (changeName.equals("minimumSize")) {
                    BasicGraphUI.this.updateCachedPreferredSize();
                } else if (changeName.equals("model")) {
                    BasicGraphUI.this.setModel((GraphModel)event.getNewValue());
                } else if (changeName.equals("view")) {
                    BasicGraphUI.this.setGraphLayoutCache((GraphLayoutCache)event.getNewValue());
                    BasicGraphUI.this.graph.repaint();
                } else if (changeName.equals("marquee")) {
                    BasicGraphUI.this.setMarquee((BasicMarqueeHandler)event.getNewValue());
                } else if (changeName.equals("editable")) {
                    boolean editable = (Boolean)event.getNewValue();
                    if (!editable && BasicGraphUI.this.isEditing(BasicGraphUI.this.graph)) {
                        BasicGraphUI.this.cancelEditing(BasicGraphUI.this.graph);
                    }
                } else if (changeName.equals("selectionModel")) {
                    BasicGraphUI.this.setSelectionModel(BasicGraphUI.this.graph.getSelectionModel());
                } else if (changeName.equals("gridVisible") || changeName.equals("gridSize") || changeName.equals("portsVisible") || changeName.equals("antiAliased")) {
                    BasicGraphUI.this.graph.repaint();
                } else if (changeName.equals("scale")) {
                    BasicGraphUI.this.updateSize();
                } else if (changeName.equals("font")) {
                    BasicGraphUI.this.completeEditing();
                    BasicGraphUI.this.updateSize();
                } else if (changeName.equals("componentOrientation") && BasicGraphUI.this.graph != null) {
                    BasicGraphUI.this.graph.graphDidChange();
                }
            }
        }
    }

    public class GraphIncrementAction
    extends AbstractAction {
        protected int direction;

        private GraphIncrementAction(int direction, String name) {
            this.direction = direction;
        }

        public void actionPerformed(ActionEvent e) {
            if (BasicGraphUI.this.graph != null) {
                int step = 70;
                Rectangle rect = BasicGraphUI.this.graph.getVisibleRect();
                if (this.direction == 1) {
                    rect.translate(0, -step);
                } else if (this.direction == 2) {
                    rect.translate(step, 0);
                } else if (this.direction == 3) {
                    rect.translate(0, step);
                } else if (this.direction == 4) {
                    rect.translate(-step, 0);
                }
                BasicGraphUI.this.graph.scrollRectToVisible(rect);
            }
        }

        public boolean isEnabled() {
            return BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.isEnabled();
        }
    }

    private class GraphCancelEditingAction
    extends AbstractAction {
        public GraphCancelEditingAction(String name) {
        }

        public void actionPerformed(ActionEvent e) {
            if (BasicGraphUI.this.graph != null) {
                BasicGraphUI.this.cancelEditing(BasicGraphUI.this.graph);
            }
        }

        public boolean isEnabled() {
            return BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.isEnabled();
        }
    }

    private class GraphEditAction
    extends AbstractAction {
        public GraphEditAction(String name) {
        }

        public void actionPerformed(ActionEvent ae) {
            if (this.isEnabled() && BasicGraphUI.this.getFocusedCell() instanceof GraphCell) {
                BasicGraphUI.this.graph.startEditingAtCell(BasicGraphUI.this.getFocusedCell());
            }
        }

        public boolean isEnabled() {
            return BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.isEnabled();
        }
    }

    private class GraphSelectAllAction
    extends AbstractAction {
        private boolean selectAll;

        public GraphSelectAllAction(String name, boolean selectAll) {
            this.selectAll = selectAll;
        }

        public void actionPerformed(ActionEvent ae) {
            if (BasicGraphUI.this.graph != null) {
                if (this.selectAll) {
                    Object[] all = new Object[BasicGraphUI.this.graphModel.getRootCount()];
                    int i = 0;
                    while (i < all.length) {
                        all[i] = BasicGraphUI.this.graphModel.getRootAt(i);
                        ++i;
                    }
                    BasicGraphUI.this.graph.addSelectionCells(all);
                } else {
                    BasicGraphUI.this.graph.clearSelection();
                }
            }
        }

        public boolean isEnabled() {
            return BasicGraphUI.this.graph != null && BasicGraphUI.this.graph.isEnabled();
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        protected Component source;
        protected Component destination;

        public MouseInputHandler(Component source, Component destination, MouseEvent event) {
            this.source = source;
            this.destination = destination;
            this.source.addMouseListener(this);
            this.source.addMouseMotionListener(this);
            destination.dispatchEvent(SwingUtilities.convertMouseEvent(source, event, destination));
        }

        public void mouseClicked(MouseEvent e) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, e, this.destination));
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, e, this.destination));
            }
            this.removeFromSource();
        }

        public void mouseEntered(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                this.removeFromSource();
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                this.removeFromSource();
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, e, this.destination));
            }
        }

        public void mouseMoved(MouseEvent e) {
            this.removeFromSource();
        }

        protected void removeFromSource() {
            if (this.source != null) {
                this.source.removeMouseListener(this);
                this.source.removeMouseMotionListener(this);
            }
            this.destination = null;
            this.source = null;
        }
    }

    public class GraphDropTargetListener
    extends BasicGraphDropTargetListener
    implements Serializable {
        protected void saveComponentState(JComponent comp) {
        }

        protected void restoreComponentState(JComponent comp) {
            if (BasicGraphUI.this.handle != null) {
                BasicGraphUI.this.handle.mouseDragged(null);
            }
        }

        protected void updateInsertionLocation(JComponent comp, Point p) {
            BasicGraphUI.this.setInsertionLocation(p);
            if (BasicGraphUI.this.handle != null) {
                int mod = BasicGraphUI.this.dropAction == 1 ? 2 : 0;
                BasicGraphUI.this.handle.mouseDragged(new MouseEvent(comp, 0, 0L, mod, p.x, p.y, 1, false));
            }
        }

        public void dragEnter(DropTargetDragEvent e) {
            BasicGraphUI.this.dropAction = e.getDropAction();
            super.dragEnter(e);
        }

        public void dropActionChanged(DropTargetDragEvent e) {
            BasicGraphUI.this.dropAction = e.getDropAction();
            super.dropActionChanged(e);
        }
    }

    public class GraphTransferHandler
    extends TransferHandler {
        protected Object out;
        protected Object in;
        protected int inCount = 0;

        public boolean canImport(JComponent comp, DataFlavor[] flavors) {
            int i = 0;
            while (i < flavors.length) {
                if (flavors[i] == GraphTransferable.dataFlavor) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Transferable createTransferable() {
            return this.createTransferable(BasicGraphUI.this.graph);
        }

        protected final Transferable createTransferable(JComponent c) {
            JGraph graph;
            Object[] cells;
            if (c instanceof JGraph && (cells = BasicGraphUI.this.graphLayoutCache.order((graph = (JGraph)c).getSelectionCells())) != null && cells.length > 0) {
                Object[] flat = BasicGraphUI.this.graphLayoutCache.order(graph.getDescendantList(cells));
                ParentMap pm = ParentMap.create(BasicGraphUI.this.graphModel, flat, false, true);
                ConnectionSet cs = ConnectionSet.create(BasicGraphUI.this.graphModel, flat, false);
                Map viewAttributes = GraphConstants.createAttributes(flat, BasicGraphUI.this.graphLayoutCache);
                Rectangle2D bounds = graph.getCellBounds(cells);
                this.out = flat;
                return this.create(graph, flat, viewAttributes, bounds, cs, pm);
            }
            return null;
        }

        protected GraphTransferable create(JGraph graph, Object[] cells, Map viewAttributes, Rectangle2D bounds, ConnectionSet cs, ParentMap pm) {
            return new GraphTransferable(cells, viewAttributes, bounds, cs, pm);
        }

        protected void exportDone(JComponent comp, Transferable data, int action) {
            if (comp instanceof JGraph && data instanceof GraphTransferable && action == 2) {
                JGraph graph = (JGraph)comp;
                Object[] cells = ((GraphTransferable)data).getCells();
                graph.getGraphLayoutCache().remove(cells);
            }
            BasicGraphUI.this.updateHandle();
            BasicGraphUI.this.setInsertionLocation(null);
        }

        public int getSourceActions(JComponent c) {
            return 3;
        }

        public boolean importData(JComponent comp, Transferable t) {
            try {
                if (comp instanceof JGraph) {
                    JGraph graph = (JGraph)comp;
                    if (t.isDataFlavorSupported(GraphTransferable.dataFlavor)) {
                        Point p = BasicGraphUI.this.getInsertionLocation();
                        Object obj = t.getTransferData(GraphTransferable.dataFlavor);
                        GraphTransferable gt = (GraphTransferable)obj;
                        Object[] cells = gt.getCells();
                        boolean allInModel = true;
                        int i = 0;
                        while (i < cells.length && allInModel) {
                            allInModel = allInModel && graph.getModel().contains(cells[i]);
                            ++i;
                        }
                        this.inCount = this.in == cells ? ++this.inCount : (allInModel ? 1 : 0);
                        this.in = cells;
                        if (p != null && this.in == this.out && BasicGraphUI.this.handle != null) {
                            int mod = BasicGraphUI.this.dropAction == 1 ? 2 : 0;
                            BasicGraphUI.this.handle.mouseReleased(new MouseEvent(comp, 0, 0L, mod, p.x, p.y, 1, false));
                            return false;
                        }
                        Rectangle2D bounds = gt.getBounds();
                        Map nested = gt.getAttributeMap();
                        ConnectionSet cs = gt.getConnectionSet();
                        ParentMap pm = gt.getParentMap();
                        if (!allInModel || p == null || BasicGraphUI.this.dropAction == 1) {
                            Map clones = graph.cloneCells(cells);
                            nested = GraphConstants.replaceKeys(clones, nested);
                            cs = cs.clone(clones);
                            pm = pm.clone(clones);
                            double dx = 0.0;
                            double dy = 0.0;
                            if (p != null) {
                                Point2D insert = graph.fromScreen(graph.snap((Point2D)p.clone()));
                                dx = insert.getX() - bounds.getX();
                                dy = insert.getY() - bounds.getY();
                            } else {
                                dx = (double)this.inCount * graph.getGridSize();
                                dy = (double)this.inCount * graph.getGridSize();
                            }
                            AttributeMap.translate(nested.values(), dx, dy);
                            Object[] newCells = new Object[cells.length];
                            int i2 = 0;
                            while (i2 < cells.length) {
                                newCells[i2] = clones.get(cells[i2]);
                                ++i2;
                            }
                            graph.getGraphLayoutCache().insert(newCells, nested, cs, pm, null);
                            return BasicGraphUI.this.dropAction == 2 && !allInModel;
                        }
                        if (p != null) {
                            Point2D insert = graph.fromScreen(graph.snap(new Point(p)));
                            double dx = insert.getX() - bounds.getX();
                            double dy = insert.getY() - bounds.getY();
                            AttributeMap.translate(nested.values(), dx, dy);
                            graph.getGraphLayoutCache().edit(nested, null, null, null);
                        }
                        graph.setSelectionCells(cells);
                        return false;
                    }
                    return this.importDataImpl(comp, t);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        protected boolean importDataImpl(JComponent comp, Transferable t) {
            return false;
        }
    }
}

