/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.util;

import java.awt.geom.Point2D;
import org.jgraph.util.Spline;

public class Spline2D {
    private double[] t;
    private Spline splineX;
    private Spline splineY;
    private double length;

    public Spline2D(Point2D[] points) {
        double[] x = new double[points.length];
        double[] y = new double[points.length];
        int i = 0;
        while (i < points.length) {
            x[i] = points[i].getX();
            y[i] = points[i].getY();
            ++i;
        }
        this.init(x, y);
    }

    public Spline2D(double[] x, double[] y) {
        this.init(x, y);
    }

    private void init(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays must have the same length.");
        }
        this.t = new double[x.length];
        int i = 0;
        while (i < this.t.length) {
            if (i == 0) {
                this.t[0] = 0.0;
            } else {
                double lx = x[i] - x[i - 1];
                double ly = y[i] - y[i - 1];
                this.t[i] = Math.sqrt(lx * lx + ly * ly);
                this.length += this.t[i];
                int n = i;
                this.t[n] = this.t[n] + this.t[i - 1];
            }
            ++i;
        }
        i = 0;
        while (i < this.t.length) {
            this.t[i] = this.t[i] / this.length;
            ++i;
        }
        this.splineX = new Spline(this.t, x);
        this.splineY = new Spline(this.t, y);
    }

    public double[] getPoint(double t) {
        double[] result = new double[]{this.splineX.getValue(t), this.splineY.getValue(t)};
        return result;
    }

    public double getDx(double t) {
        return this.splineX.getDx(t);
    }

    public double getDy(double t) {
        return this.splineY.getDx(t);
    }

    public double getLength() {
        return this.length;
    }
}

